/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.gen;

import com.iteaj.iboot.msn.lcd.gen.DesignTableInfo;
import com.iteaj.iboot.msn.lcd.gen.LcdField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.springframework.util.CollectionUtils;

public class JoinFieldParse {
    private List<LcdField> fields;
    private List<LcdField> foreign;
    private DesignTableInfo tableInfo;

    public JoinFieldParse(DesignTableInfo tableInfo, List<LcdField> foreign, List<LcdField> fields) {
        this.fields = fields;
        this.foreign = foreign;
        this.tableInfo = tableInfo;
    }

    public String resolve() {
        char startAlias = 'a';
        HashMap<String, Character> tableAlias = new HashMap<String, Character>();
        tableAlias.put(this.tableInfo.getName(), Character.valueOf(startAlias));
        StringBuilder sb = new StringBuilder("select a.* from ").append(this.tableInfo.getName()).append(" ").append(startAlias).append("\r\t");
        if (!CollectionUtils.isEmpty(this.fields) && !CollectionUtils.isEmpty(this.foreign)) {
            IntStream.range(0, this.foreign.size()).forEach(value -> {
                LcdField lcdField = this.foreign.get(value);
                char alias = (char)(startAlias + value + 1);
                tableAlias.put(lcdField.getTable(), Character.valueOf(alias));
                sb.append(" left join ").append(lcdField.getTable()).append(" ").append(alias).append("\r\t");
            });
            HashMap lcdFieldMap = new HashMap();
            this.fields.forEach(field -> {
                ArrayList<LcdField> lcdFields = (ArrayList<LcdField>)lcdFieldMap.get(field.getTable());
                if (lcdFields == null) {
                    lcdFields = new ArrayList<LcdField>();
                }
                lcdFields.add((LcdField)((Object)field));
            });
        }
        return sb.toString();
    }

    public List<LcdField> getFields() {
        return this.fields;
    }

    public List<LcdField> getForeign() {
        return this.foreign;
    }

    public DesignTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setFields(List<LcdField> fields) {
        this.fields = fields;
    }

    public void setForeign(List<LcdField> foreign) {
        this.foreign = foreign;
    }

    public void setTableInfo(DesignTableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinFieldParse)) {
            return false;
        }
        JoinFieldParse other = (JoinFieldParse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LcdField> this$fields = this.getFields();
        List<LcdField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List<LcdField> this$foreign = this.getForeign();
        List<LcdField> other$foreign = other.getForeign();
        if (this$foreign == null ? other$foreign != null : !((Object)this$foreign).equals(other$foreign)) {
            return false;
        }
        DesignTableInfo this$tableInfo = this.getTableInfo();
        DesignTableInfo other$tableInfo = other.getTableInfo();
        return !(this$tableInfo == null ? other$tableInfo != null : !((Object)((Object)this$tableInfo)).equals((Object)other$tableInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinFieldParse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LcdField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List<LcdField> $foreign = this.getForeign();
        result = result * 59 + ($foreign == null ? 43 : ((Object)$foreign).hashCode());
        DesignTableInfo $tableInfo = this.getTableInfo();
        result = result * 59 + ($tableInfo == null ? 43 : ((Object)((Object)$tableInfo)).hashCode());
        return result;
    }

    public String toString() {
        return "JoinFieldParse(fields=" + this.getFields() + ", foreign=" + this.getForeign() + ", tableInfo=" + (Object)((Object)this.getTableInfo()) + ")";
    }
}

