/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.design;

import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.iteaj.iboot.msn.lcd.LowCodeProperties;
import com.iteaj.iboot.msn.lcd.design.ILcdFileCreate;
import com.iteaj.iboot.msn.lcd.design.LcdInjectionConfig;
import com.iteaj.iboot.msn.lcd.gen.DesignConfigBuilder;
import com.iteaj.iboot.msn.lcd.gen.DesignTableInfo;
import com.iteaj.iboot.msn.lcd.utils.LowCodeUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class LcdVueInjectionConfig
extends LcdInjectionConfig {
    private LowCodeProperties properties;

    public LcdVueInjectionConfig(DesignConfigBuilder builder, LowCodeProperties properties) {
        this.setConfig(builder);
        this.properties = properties;
    }

    @Override
    public void initMap() {
        this.setMap(new HashMap<String, Object>());
    }

    @Override
    public void initTableMap(TableInfo tableInfo) {
        this.setMap(new HashMap<String, Object>());
        DesignTableInfo info = (DesignTableInfo)tableInfo;
        this.getMap().put("formFields", info.getFormFields());
        this.getMap().put("searchFields", info.getSearchFields());
        this.getMap().put("tableFields", info.getFormTableFields());
        this.getMap().put("moduleName", LowCodeUtil.getModuleName(tableInfo.getComment()));
        String serviceName = tableInfo.getServiceName();
        this.getMap().put("serviceName", LowCodeUtil.firstLowerServiceName(serviceName));
    }

    @Override
    public List<FileOutConfig> getFileOutConfigList() {
        return Arrays.asList(new FileOutConfig(){

            public String getTemplatePath() {
                return "/templates/lcd.ivzone.vue.vm";
            }

            public String outputFile(TableInfo tableInfo) {
                String moduleName = LcdVueInjectionConfig.this.getConfig().getPackageInfo().get("ModuleName");
                String entityName = tableInfo.getEntityPath();
                return moduleName + File.separator + entityName + File.separator + "index.vue";
            }
        });
    }

    @Override
    public ILcdFileCreate getFileCreate() {
        return (configBuilder, fileType, filePath) -> {
            if (fileType != FileType.OTHER) {
                return false;
            }
            return filePath.endsWith(".vue");
        };
    }
}

