/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.lcd.dto.TableOptionsDto;
import com.iteaj.iboot.msn.lcd.entity.LcdDesign;
import com.iteaj.iboot.msn.lcd.service.ILcdDesignService;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lcd/design"})
public class LcdDesignController
extends BaseController {
    private final ILcdDesignService lcdDesignService;

    public LcdDesignController(ILcdDesignService lcdDesignService) {
        this.lcdDesignService = lcdDesignService;
    }

    @GetMapping(value={"/view"})
    public Result<IPage<LcdDesign>> list(Page<LcdDesign> page, LcdDesign entity) {
        return this.lcdDesignService.page((IPage)page, (Wrapper)Wrappers.query((Object)((Object)entity)).select(new String[]{"id", "name", "table_name", "comment", "create_time", "update_time", "table_exists"}));
    }

    @GetMapping(value={"/edit"})
    public Result<LcdDesign> getEditDetail(Long id) {
        return this.lcdDesignService.getById(id);
    }

    @PostMapping(value={"/edit"})
    public Result<Boolean> edit(@RequestBody LcdDesign entity) {
        return this.lcdDesignService.updateById((Entity)entity);
    }

    @PostMapping(value={"/add"})
    public Result<Long> add(@RequestBody LcdDesign entity) {
        return this.lcdDesignService.save((Entity)entity).of().map(item -> this.success(entity.getId())).get();
    }

    @PostMapping(value={"/del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.lcdDesignService.removeByIds(idList);
    }

    @GetMapping(value={"foreign"})
    public Result<List<TableOptionsDto>> foreign(Long id) {
        List<TableOptionsDto> tableOptionsDtos = this.lcdDesignService.listForeign(id);
        return this.success(tableOptionsDtos);
    }

    @GetMapping(value={"columns"})
    public Result<List<TableOptionsDto>> columns(String tableName) {
        List<TableOptionsDto> tableOptionsDtos = this.lcdDesignService.listColumns(tableName);
        return this.success(tableOptionsDtos);
    }
}

