/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.utils;

import com.iteaj.framework.TreeEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class TreeUtils {
    public static <T extends TreeEntity> Collection<T> toTrees(Collection<T> list) {
        return TreeUtils.toTrees(list, null);
    }

    public static <T extends TreeEntity> Collection<T> toTrees(Collection<T> list, Long parent) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        Map<String, TreeEntity> menuMap = list.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
        ArrayList parents = new ArrayList();
        list.forEach(item -> {
            TreeEntity parentItem = (TreeEntity)menuMap.get(item.getPid().toString());
            if (null != parentItem) {
                parentItem.addChild((TreeEntity)item);
            } else {
                parents.add(item);
            }
        });
        if (parent != null) {
            return list.stream().filter(item -> item.getPid().equals(parent)).collect(Collectors.toList());
        }
        return parents;
    }

    public static <T extends TreeEntity> Collection<T> toAdminMenuTrees(List<T> allMenus, List<String> adminMenuIds) {
        Map<String, TreeEntity> menuMap = allMenus.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
        HashMap adminMenus = new HashMap();
        adminMenuIds.forEach(item -> {
            TreeEntity t = (TreeEntity)menuMap.get(item);
            if (t != null) {
                if (!adminMenus.containsKey(item)) {
                    adminMenus.put(item, t);
                }
                TreeUtils.getParentMenu(t.getPid(), menuMap, adminMenus);
            }
        });
        return TreeUtils.toTrees(adminMenus.values(), 0L);
    }

    private static <T extends TreeEntity> void getParentMenu(Long pid, Map<String, T> menuMap, Map<String, T> adminMenus) {
        if (pid == null) {
            return;
        }
        String pidStr = String.valueOf(pid);
        TreeEntity parentMenu = (TreeEntity)menuMap.get(pidStr);
        if (parentMenu != null && !adminMenus.containsKey(pidStr)) {
            parentMenu.setChildren(null);
            adminMenus.put(pidStr, parentMenu);
            TreeUtils.getParentMenu(parentMenu.getPid(), menuMap, adminMenus);
        }
    }
}

