/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.spi.auth;

import com.iteaj.framework.result.HttpResult;
import com.iteaj.framework.result.Result;
import com.iteaj.framework.spi.auth.AuthContext;
import com.iteaj.framework.spi.auth.AuthToken;
import com.iteaj.framework.spi.auth.SecurityException;
import com.iteaj.framework.web.WebUtils;
import com.iteaj.util.JsonUtils;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public interface WebAuthAction<T>
extends Ordered {
    public static final long expireTime = 1800L;
    public static final PathMatcher pathMatcher = new AntPathMatcher();

    default public int getOrder() {
        return 88;
    }

    default public String getName() {
        return this.getClass().getName();
    }

    default public long expireTime() {
        return 1800L;
    }

    default public String getTokenName() {
        return null;
    }

    default public boolean isAjax(HttpServletRequest request) {
        String ajaxId = request.getHeader("x-requested-with");
        return "XMLHttpRequest".equalsIgnoreCase(ajaxId);
    }

    default public boolean pathMatcher(String uri, HttpServletRequest request) {
        for (String url : this.getUrlPattern()) {
            if (!pathMatcher.match(url, uri)) continue;
            return true;
        }
        return false;
    }

    default public boolean isLoginRequest(HttpServletRequest request) {
        String loginUrl = this.getLoginUrl();
        if (loginUrl != null) {
            String requestUri = WebUtils.getRequestUriContext(request);
            return loginUrl.equalsIgnoreCase(requestUri);
        }
        return false;
    }

    default public void writeJson(Result result, HttpServletResponse response) {
        response.setContentType("application/json;charset=utf-8");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            String toJson = JsonUtils.toJson((Object)result);
            outputStream.write(toJson.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public String getLoginUrl() {
        return null;
    }

    default public String getSuccessUrl() {
        return null;
    }

    public String[] getUrlPattern();

    public boolean preAuthorize(HttpServletRequest var1, HttpServletResponse var2);

    public AuthContext getContext(HttpServletRequest var1, HttpServletResponse var2);

    public boolean postAuthorize(HttpServletRequest var1, HttpServletResponse var2) throws SecurityException;

    public AuthToken login(T var1, HttpServletRequest var2, HttpServletResponse var3) throws SecurityException;

    default public void logout(HttpServletRequest request, HttpServletResponse response) {
        if (this.isAjax(request)) {
            this.writeJson(HttpResult.Success(this.getLoginUrl(), "\u6ce8\u9500\u6210\u529f"), response);
        } else {
            try {
                response.sendRedirect(this.getLoginUrl());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    default public boolean loginCall(Exception cause, HttpServletRequest request, HttpServletResponse response) {
        if (response.isCommitted()) {
            return false;
        }
        if (cause == null) {
            if (this.isAjax(request)) {
                this.writeJson(HttpResult.Success(this.getSuccessUrl(), "\u767b\u5f55\u6210\u529f"), response);
            } else {
                try {
                    response.sendRedirect(this.getSuccessUrl());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Throwable throwable = cause;
            if (cause instanceof UndeclaredThrowableException) {
                throwable = ((UndeclaredThrowableException)cause).getUndeclaredThrowable().getCause();
            }
            cause.printStackTrace();
            if (this.isAjax(request)) {
                if (throwable instanceof SecurityException) {
                    this.writeJson(HttpResult.Fail(throwable.getMessage()), response);
                } else {
                    this.writeJson(HttpResult.Fail("\u767b\u5f55\u5931\u8d25"), response);
                }
            } else {
                try {
                    response.sendRedirect(this.getLoginUrl());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

