/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.security.shiro.redis;

import com.iteaj.framework.autoconfigure.SessionCacheProperties;
import com.iteaj.framework.security.shiro.ShiroUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MapCache;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.CollectionUtils;

public class ShiroRedisSessionCacheManager
implements CacheManager,
InitializingBean {
    private RedisTemplate redisTemplate;
    private SessionCacheProperties config;
    private ValueOperations valueOperations;
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();

    public ShiroRedisSessionCacheManager(RedisTemplate redisTemplate, SessionCacheProperties config) {
        this.redisTemplate = redisTemplate;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String s) throws CacheException {
        Cache cache = (Cache)this.caches.get(s);
        if (cache == null) {
            ConcurrentMap<String, Cache> concurrentMap = this.caches;
            synchronized (concurrentMap) {
                cache = (Cache)this.caches.get(s);
                if (cache != null) {
                    return cache;
                }
                cache = new MapCache(s, new HashMap());
                this.caches.put(s, cache);
            }
        }
        return cache;
    }

    public void afterPropertiesSet() throws Exception {
        this.valueOperations = this.redisTemplate.opsForValue();
        this.caches.put(this.config.getName(), new RedisSessionCache());
    }

    protected class RedisSessionCache
    implements Cache<String, Session> {
        protected RedisSessionCache() {
        }

        public Session get(String s) throws CacheException {
            Session session = (Session)ShiroUtil.getRequestAttr(s);
            if (session != null) {
                return session;
            }
            session = (Session)ShiroRedisSessionCacheManager.this.valueOperations.get((Object)("IFSCF:" + s));
            if (session != null) {
                ShiroUtil.setRequestAttr(s, session);
            }
            return session;
        }

        public Session put(String s, Session session) throws CacheException {
            ShiroRedisSessionCacheManager.this.valueOperations.set((Object)("IFSCF:" + s), (Object)session, session.getTimeout(), TimeUnit.MILLISECONDS);
            ShiroUtil.setRequestAttr(s, session);
            return session;
        }

        public Session remove(String s) throws CacheException {
            Session session = this.get("IFSCF:" + s);
            if (session != null) {
                ShiroRedisSessionCacheManager.this.redisTemplate.delete((Object)("IFSCF:" + s));
            }
            return session;
        }

        public void clear() throws CacheException {
            Set<String> keys = this.keys();
            if (!this.keys().isEmpty()) {
                ShiroRedisSessionCacheManager.this.redisTemplate.delete(keys);
            }
        }

        public int size() {
            return this.keys().size();
        }

        public Set<String> keys() {
            Set keys = ShiroRedisSessionCacheManager.this.redisTemplate.keys((Object)"IFSCF:*");
            if (!CollectionUtils.isEmpty((Collection)keys)) {
                return keys.stream().map(key -> key.split(":")[1]).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }

        public Collection<Session> values() {
            return Collections.emptyList();
        }
    }
}

