/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.security.shiro;

import com.iteaj.framework.spi.auth.WebAuthHandler;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroAuthAccessFilter
extends AccessControlFilter {
    private WebAuthHandler handler;
    protected static Logger logger = LoggerFactory.getLogger(WebAuthHandler.class);

    public ShiroAuthAccessFilter(WebAuthHandler webAuthHandler) {
        this.handler = webAuthHandler;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        if (!this.handler.preAuthorize(servletRequest, servletResponse)) {
            return true;
        }
        boolean authenticated = SecurityUtils.getSubject().isAuthenticated();
        return authenticated;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        return !this.handler.postAuthorize((HttpServletRequest)request, (HttpServletResponse)response);
    }
}

