/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.autoconfigure;

import com.iteaj.framework.autoconfigure.FrameworkAutoConfiguration;
import com.iteaj.framework.autoconfigure.FrameworkProperties;
import com.iteaj.framework.cache.CacheEntry;
import com.iteaj.framework.cache.SerializerType;
import com.iteaj.framework.spi.auth.WebAuthAction;
import com.iteaj.framework.spi.auth.WebAuthHandler;
import com.iteaj.framework.spi.auth.handle.AccountAuthHandler;
import java.util.List;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ImportAutoConfiguration(value={FrameworkAutoConfiguration.class})
public class FrameworkWebConfiguration
implements WebMvcConfigurer {
    private final FrameworkProperties properties;

    public FrameworkWebConfiguration(FrameworkProperties properties) {
        this.properties = properties;
    }

    @Bean
    public CacheEntry sessionCacheEntry() {
        FrameworkProperties.Auth auth = this.properties.getAuth();
        return new CacheEntry("WEB_SESSION_CACHE", auth.getTimeout(), SerializerType.Jdk);
    }

    @Bean
    @ConditionalOnMissingBean(value={WebAuthHandler.class})
    public WebAuthHandler appAuthHandler(List<WebAuthAction> actions) {
        return new AccountAuthHandler(actions);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String uploadRootUri = this.properties.getUploadPattern();
        String uploadRootDir = this.properties.getUploadLocation();
        if (uploadRootUri != null && uploadRootDir != null) {
            uploadRootUri = uploadRootUri.endsWith("/") ? uploadRootUri + "**" : uploadRootUri + "/**";
            if (!uploadRootDir.endsWith("/")) {
                uploadRootDir = uploadRootDir + "/";
            }
            registry.addResourceHandler(new String[]{uploadRootUri}).addResourceLocations(new String[]{"file:" + uploadRootDir});
        }
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"classpath:/static/"});
    }
}

