/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.UpdateChainWrapper;
import com.baomidou.mybatisplus.extension.toolkit.ChainWrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.BooleanResult;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.result.ListResult;
import com.iteaj.framework.result.NumberResult;
import com.iteaj.framework.result.PageResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public interface IBaseService<E extends Entity> {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    default public BooleanResult save(E entity) {
        return new BooleanResult(SqlHelper.retBool((Integer)this.getBaseMapper().insert(entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    default public BooleanResult saveBatch(Collection<E> entityList) {
        return this.saveBatch(entityList, 1000);
    }

    public BooleanResult saveBatch(Collection<E> var1, int var2);

    @Transactional(rollbackFor={Exception.class})
    default public BooleanResult saveOrUpdateBatch(Collection<E> entityList) {
        return this.saveOrUpdateBatch(entityList, 1000);
    }

    public BooleanResult saveOrUpdateBatch(Collection<E> var1, int var2);

    default public BooleanResult removeById(Serializable id) {
        return new BooleanResult(SqlHelper.retBool((Integer)this.getBaseMapper().deleteById(id)));
    }

    default public BooleanResult removeByMap(Map<String, Object> columnMap) {
        Assert.notEmpty(columnMap, (String)"error: columnMap must not be empty", (Object[])new Object[0]);
        return new BooleanResult(SqlHelper.retBool((Integer)this.getBaseMapper().deleteByMap(columnMap)));
    }

    default public BooleanResult remove(Wrapper<E> queryWrapper) {
        return new BooleanResult(SqlHelper.retBool((Integer)this.getBaseMapper().delete(queryWrapper)));
    }

    default public BooleanResult removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return new BooleanResult(false);
        }
        return new BooleanResult(SqlHelper.retBool((Integer)this.getBaseMapper().deleteBatchIds(idList)));
    }

    default public BooleanResult updateById(E entity) {
        return new BooleanResult(SqlHelper.retBool((Integer)this.getBaseMapper().updateById(entity)));
    }

    default public BooleanResult update(Wrapper<E> updateWrapper) {
        return this.update(null, updateWrapper);
    }

    default public BooleanResult update(E entity, Wrapper<E> updateWrapper) {
        return new BooleanResult(SqlHelper.retBool((Integer)this.getBaseMapper().update(entity, updateWrapper)));
    }

    @Transactional(rollbackFor={Exception.class})
    default public BooleanResult updateBatchById(Collection<E> entityList) {
        return this.updateBatchById(entityList, 1000);
    }

    public BooleanResult updateBatchById(Collection<E> var1, int var2);

    public BooleanResult saveOrUpdate(E var1);

    default public DetailResult<E> getById(Serializable id) {
        return new DetailResult<Entity>((Entity)this.getBaseMapper().selectById(id));
    }

    default public ListResult<E> listByIds(Collection<? extends Serializable> idList) {
        return new ListResult(this.getBaseMapper().selectBatchIds(idList));
    }

    default public ListResult<E> listByMap(Map<String, Object> columnMap) {
        return new ListResult(this.getBaseMapper().selectByMap(columnMap));
    }

    default public DetailResult<E> getOne(Wrapper<E> queryWrapper) {
        return this.getOne(queryWrapper, true);
    }

    public DetailResult<E> getOne(Wrapper<E> var1, boolean var2);

    public Map<String, Object> getMap(Wrapper<E> var1);

    public <V> V getObj(Wrapper<E> var1, Function<? super Object, V> var2);

    default public NumberResult<Integer> count() {
        return this.count((Wrapper<E>)Wrappers.emptyWrapper());
    }

    default public NumberResult<Integer> count(Wrapper<E> queryWrapper) {
        return new NumberResult<Integer>(SqlHelper.retCount((Integer)this.getBaseMapper().selectCount(queryWrapper)));
    }

    default public ListResult<E> list(E condition) {
        return this.list((Wrapper<E>)Wrappers.query(condition));
    }

    default public ListResult<E> list(Wrapper<E> queryWrapper) {
        return new ListResult(this.getBaseMapper().selectList(queryWrapper));
    }

    default public ListResult<E> list() {
        return this.list((Wrapper<E>)Wrappers.emptyWrapper());
    }

    default public PageResult<IPage<E>> page(IPage<E> page, E condition) {
        return this.page((IPage)page, (Wrapper<E>)Wrappers.query(condition));
    }

    default public <T extends IPage<E>> PageResult<T> page(T page, Wrapper<E> queryWrapper) {
        return new PageResult<IPage>(this.getBaseMapper().selectPage(page, queryWrapper));
    }

    default public <T extends IPage<E>> PageResult<T> page(T page) {
        return this.page(page, (Wrapper<E>)Wrappers.emptyWrapper());
    }

    default public List<Map<String, Object>> listMaps(Wrapper<E> queryWrapper) {
        return this.getBaseMapper().selectMaps(queryWrapper);
    }

    default public List<Map<String, Object>> listMaps() {
        return this.listMaps((Wrapper<E>)Wrappers.emptyWrapper());
    }

    default public List<Object> listObjs() {
        return (List)this.listObjs(Function.identity()).getData();
    }

    default public <V> ListResult<V> listObjs(Function<? super Object, V> mapper) {
        return this.listObjs((Wrapper<E>)Wrappers.emptyWrapper(), mapper);
    }

    default public List<Object> listObjs(Wrapper<E> queryWrapper) {
        return (List)this.listObjs(queryWrapper, Function.identity()).getData();
    }

    default public <V> ListResult<V> listObjs(Wrapper<E> queryWrapper, Function<? super Object, V> mapper) {
        return new ListResult(this.getBaseMapper().selectObjs(queryWrapper).stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList()));
    }

    default public <P extends IPage<Map<String, Object>>> PageResult<P> pageMaps(P page, Wrapper<E> queryWrapper) {
        return new PageResult<IPage>(this.getBaseMapper().selectMapsPage(page, queryWrapper));
    }

    default public <P extends IPage<Map<String, Object>>> PageResult<P> pageMaps(P page) {
        return this.pageMaps(page, (Wrapper<E>)Wrappers.emptyWrapper());
    }

    public BaseMapper<E> getBaseMapper();

    public Class<E> getEntityClass();

    default public QueryChainWrapper<E> query() {
        return ChainWrappers.queryChain(this.getBaseMapper());
    }

    default public LambdaQueryChainWrapper<E> lambdaQuery() {
        return ChainWrappers.lambdaQueryChain(this.getBaseMapper());
    }

    default public UpdateChainWrapper<E> update() {
        return ChainWrappers.updateChain(this.getBaseMapper());
    }

    default public LambdaUpdateChainWrapper<E> lambdaUpdate() {
        return ChainWrappers.lambdaUpdateChain(this.getBaseMapper());
    }

    default public BooleanResult saveOrUpdate(E entity, Wrapper<E> updateWrapper) {
        BooleanResult update = this.update(entity, updateWrapper);
        return update.getData() == true ? update : this.saveOrUpdate(entity);
    }
}

