/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.iteaj.framework.Entity;
import com.iteaj.framework.IBaseService;
import com.iteaj.framework.result.BooleanResult;
import com.iteaj.framework.result.DetailResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseServiceImpl<M extends BaseMapper<T>, T extends Entity>
implements IBaseService<T> {
    protected Log log = LogFactory.getLog(this.getClass());
    @Autowired
    protected M baseMapper;
    protected Class<T> entityClass = this.currentModelClass();
    protected Class<T> mapperClass = this.currentMapperClass();

    public M getBaseMapper() {
        return this.baseMapper;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    protected Class<T> currentMapperClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), (int)0);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), (int)1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BooleanResult saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return new BooleanResult(this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity)));
    }

    protected String getSqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.getSqlStatement(this.mapperClass, (SqlMethod)sqlMethod);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BooleanResult saveOrUpdate(T entity) {
        if (null != entity) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(this.entityClass);
            Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
            Object idVal = ReflectionKit.getFieldValue(entity, (String)tableInfo.getKeyProperty());
            return StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.getById((Serializable)idVal)) ? this.save(entity) : this.updateById(entity);
        }
        return new BooleanResult(false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BooleanResult saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.entityClass);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        return new BooleanResult(SqlHelper.saveOrUpdateBatch(this.entityClass, this.mapperClass, (Log)this.log, entityList, (int)batchSize, (sqlSession, entity) -> {
            Object idVal = ReflectionKit.getFieldValue((Object)entity, (String)keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(this.getSqlStatement(SqlMethod.SELECT_BY_ID), entity));
        }, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(this.getSqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
        }));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BooleanResult updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return new BooleanResult(this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        }));
    }

    @Override
    public DetailResult getOne(Wrapper<T> queryWrapper, boolean throwEx) {
        if (throwEx) {
            return new DetailResult<Entity>((Entity)this.baseMapper.selectOne(queryWrapper));
        }
        return new DetailResult<Entity>((Entity)SqlHelper.getObject((Log)this.log, (List)this.baseMapper.selectList(queryWrapper)));
    }

    @Override
    public Map<String, Object> getMap(Wrapper<T> queryWrapper) {
        return (Map)SqlHelper.getObject((Log)this.log, (List)this.baseMapper.selectMaps(queryWrapper));
    }

    @Override
    public <V> V getObj(Wrapper<T> queryWrapper, Function<? super Object, V> mapper) {
        return (V)SqlHelper.getObject((Log)this.log, (List)((List)this.listObjs(queryWrapper, mapper).getData()));
    }

    @Deprecated
    protected boolean executeBatch(Consumer<SqlSession> consumer) {
        return SqlHelper.executeBatch(this.entityClass, (Log)this.log, consumer);
    }

    protected <E> boolean executeBatch(Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        return SqlHelper.executeBatch(this.entityClass, (Log)this.log, list, (int)batchSize, consumer);
    }

    protected <E> boolean executeBatch(Collection<E> list, BiConsumer<SqlSession, E> consumer) {
        return this.executeBatch(list, 1000, consumer);
    }
}

