/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iteaj.iboot.msn.iot.consts.DeviceStatus;
import com.iteaj.iboot.msn.iot.entity.Device;
import com.iteaj.iboot.msn.iot.service.IDeviceService;
import com.iteaj.iot.FrameworkComponent;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.SocketClient;
import com.iteaj.iot.event.ClientStatusEventListener;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerComponent;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class DeviceStatusListener
implements ClientStatusEventListener,
DisposableBean {
    private final IDeviceService deviceService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DeviceStatusListener(IDeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public void online(Object source, FrameworkComponent component) {
        if (source instanceof String) {
            if (!(component instanceof DefaultWebSocketServerComponent)) {
                this.deviceService.update((String)source, DeviceStatus.online);
            }
        } else if (source instanceof SocketClient) {
            ClientConnectProperties config = ((SocketClient)source).getConfig();
            this.deviceService.update(config.connectKey(), DeviceStatus.online);
        }
    }

    public void offline(Object source, FrameworkComponent component) {
        if (source instanceof String) {
            this.deviceService.update((String)source, DeviceStatus.offline);
        } else if (source instanceof SocketClient) {
            ClientConnectProperties config = ((SocketClient)source).getConfig();
            this.deviceService.update(config.connectKey(), DeviceStatus.offline);
        }
    }

    public void destroy() throws Exception {
        this.deviceService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Device::getStatus, (Object)DeviceStatus.offline)).set(Device::getSwitchTime, (Object)new Date()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u7a0b\u5e8f\u5173\u95ed... \u66f4\u65b0\u6240\u6709\u8bbe\u5907\u72b6\u6001\u5230[offline]");
        }
    }
}

