/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.iteaj.framework.BaseServiceImpl;
import com.iteaj.framework.Entity;
import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.iboot.msn.core.dto.AdminDto;
import com.iteaj.iboot.msn.core.entity.Admin;
import com.iteaj.iboot.msn.core.mapper.IAdminDao;
import com.iteaj.iboot.msn.core.service.IAdminService;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.DigestUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminServiceImpl
extends BaseServiceImpl<IAdminDao, Admin>
implements IAdminService {
    public Admin getByAccount(String username) {
        return (Admin)((IAdminDao)this.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().eq((Object)"account", (Object)username));
    }

    @Transactional
    public void createAdmin(AdminDto adminDto) {
        if (null == adminDto) {
            throw new ServiceException("\u521b\u5efa\u5931\u8d25");
        }
        Admin byAccount = this.getByAccount(adminDto.getAccount());
        if (null != byAccount) {
            throw new ServiceException("\u6b64\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff1a" + adminDto.getAccount());
        }
        if (CommonUtils.isNotBlank((String)adminDto.getPassword())) {
            adminDto.setPassword(DigestUtils.md5Hex((byte[])adminDto.getPassword().getBytes()));
        } else {
            adminDto.setPassword(DigestUtils.md5Hex((byte[])adminDto.getAccount().getBytes()));
        }
        ((IAdminDao)this.getBaseMapper()).createAdmin(adminDto);
    }

    @Transactional
    public void updateAdminAndRole(AdminDto adminDto) {
        this.updateById((Entity)adminDto.setUpdateTime(new Date()));
        ((IAdminDao)this.getBaseMapper()).updateAdminRole(adminDto);
    }

    public DetailResult<AdminDto> getAdminDetailById(Long id) {
        return new DetailResult((Entity)((IAdminDao)this.getBaseMapper()).getAdminDetailById(id));
    }

    public void updatePwdById(Long id, String password, String oldPwd) {
        String oldPassword;
        if (null == id || CommonUtils.isBlank((String)password)) {
            throw new ServiceException("\u66f4\u65b0\u5bc6\u7801\u5931\u8d25");
        }
        if (CommonUtils.isBlank((String)oldPwd)) {
            throw new ServiceException("\u8bf7\u8f93\u5165\u539f\u5bc6\u7801");
        }
        if (!(oldPwd = DigestUtils.md5Hex((byte[])oldPwd.getBytes())).equalsIgnoreCase(oldPassword = ((IAdminDao)this.getBaseMapper()).getAdminPassword(id))) {
            throw new ServiceException("\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        String md5Hex = DigestUtils.md5Hex((byte[])password.getBytes());
        ((IAdminDao)this.getBaseMapper()).updatePwdById(id, md5Hex);
    }

    public void deleteAllJoinByIds(List<Long> list) {
        if (CommonUtils.isNotEmpty(list)) {
            ((IAdminDao)this.getBaseMapper()).deleteAllJoinByIds(list);
        }
    }

    public List<String> selectPermsById(Serializable id) {
        return ((IAdminDao)this.getBaseMapper()).selectPermsById(id);
    }

    public void updateCurrentUserInfo(Admin admin) {
        if (CommonUtils.isNotBlank((String)admin.getPassword())) {
            String md5Hex = DigestUtils.md5Hex((byte[])admin.getPassword().getBytes());
            admin.setPassword(md5Hex);
        }
        this.updateById((Entity)admin);
        Admin principal = (Admin)ShiroUtil.getUser();
        principal.setAvatar(admin.getAvatar()).setEmail(admin.getEmail()).setPhone(admin.getPhone()).setRemark(admin.getRemark()).setName(admin.getName()).setSex(admin.getSex());
    }

    public DetailResult<AdminDto> getAdminCenter(Serializable id) {
        return new DetailResult((Entity)((IAdminDao)this.getBaseMapper()).getAdminCenter(id));
    }

    public void setAdminPassword(Long id, String password) {
        if (null == id || CommonUtils.isBlank((String)password)) {
            throw new ServiceException("\u8bf7\u68c0\u67e5\u8981\u8bbe\u7f6e\u7684\u5bc6\u7801");
        }
        this.getById((Serializable)id).ofNullable().orElseThrow(() -> new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728"));
        String md5Hex = DigestUtils.md5Hex((byte[])password.getBytes());
        ((IAdminDao)this.getBaseMapper()).updatePwdById(id, md5Hex);
    }
}

