/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.service;

import com.iteaj.framework.Entity;
import com.iteaj.framework.logger.AccessLogger;
import com.iteaj.framework.logger.LoggerService;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.iboot.msn.core.entity.AccessLog;
import com.iteaj.iboot.msn.core.entity.Admin;
import com.iteaj.iboot.msn.core.entity.Menu;
import com.iteaj.iboot.msn.core.service.IAccessLogService;
import com.iteaj.iboot.msn.core.service.IMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;

public class AdminLoggerService
implements LoggerService {
    @Autowired
    private IMenuService menuService;
    @Autowired
    private IAccessLogService operaLogService;

    @Async
    public void record(AccessLogger entity) {
        Menu menu;
        AccessLog accessLog = new AccessLog().setErrMsg(entity.getRemark()).setIp(entity.getIp()).setUrl(entity.getUrl()).setMillis(Long.valueOf(entity.getExecTime())).setStatus(Boolean.valueOf(entity.isStatus()));
        if (ShiroUtil.isLogin()) {
            Admin admin = (Admin)ShiroUtil.getUser();
            accessLog.setUserId(admin.getId()).setUserName(admin.getName());
        }
        if ((menu = this.getLoggerMenu(entity.getUrl())) != null) {
            Menu parent;
            accessLog.setTitle(menu.getName());
            Long pid = menu.getPid();
            if (pid != null && pid > 0L && (parent = this.menuService.getByIdFromCache(pid)) != null) {
                accessLog.setMsn(parent.getName());
            }
        }
        this.operaLogService.save((Entity)accessLog);
    }

    public Menu getLoggerMenu(String url) {
        return this.menuService.getByUrlFromCache(url);
    }
}

