/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.vue;

import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.IFileCreate;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.iteaj.iboot.msn.lcd.LowCodeProperties;
import com.iteaj.iboot.msn.lcd.utils.LowCodeUtil;
import com.iteaj.iboot.msn.lcd.vue.VueFieldInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class VueInjectionConfig
extends InjectionConfig {
    private LowCodeProperties properties;

    public VueInjectionConfig(ConfigBuilder builder, LowCodeProperties properties) {
        this.setConfig(builder);
        this.properties = properties;
    }

    public void initMap() {
        this.setMap(new HashMap());
    }

    public void initTableMap(TableInfo tableInfo) {
        this.setMap(new HashMap());
        List vueFields = tableInfo.getFields().stream().map(item -> {
            if (item.isKeyIdentityFlag()) {
                this.getMap().put("rowKey", item.getPropertyName());
            }
            return new VueFieldInfo((TableField)item).build(this.properties);
        }).filter(item -> item != null).collect(Collectors.toList());
        this.getMap().put("vueFields", vueFields);
        this.getMap().put("moduleName", LowCodeUtil.getModuleName(tableInfo.getComment()));
    }

    public List<FileOutConfig> getFileOutConfigList() {
        return Arrays.asList(new FileOutConfig(){

            public String getTemplatePath() {
                return "/templates/ivzone.vue.vm";
            }

            public String outputFile(TableInfo tableInfo) {
                String moduleName = (String)VueInjectionConfig.this.getConfig().getPackageInfo().get("ModuleName");
                String entityName = tableInfo.getEntityPath();
                return moduleName + "/" + entityName + "/index.vue";
            }
        });
    }

    public IFileCreate getFileCreate() {
        return (configBuilder, fileType, filePath) -> {
            if (fileType != FileType.OTHER) {
                return false;
            }
            return filePath.endsWith(".vue");
        };
    }
}

