/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd;

import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.IFileCreate;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import com.iteaj.iboot.msn.lcd.LowCodeProperties;
import com.iteaj.iboot.msn.lcd.dto.ReviewDto;
import com.iteaj.iboot.msn.lcd.utils.LowCodeUtil;
import com.iteaj.iboot.msn.lcd.vue.VueInjectionConfig;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityReviewTemplateEngine
extends VelocityTemplateEngine {
    private VelocityEngine velocityEngine;
    private LowCodeProperties properties;
    private ReviewDto reviewDto = new ReviewDto();

    public VelocityReviewTemplateEngine(LowCodeProperties properties) {
        this.properties = properties;
    }

    public VelocityTemplateEngine init(ConfigBuilder configBuilder) {
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("resource.loader.file.path", "");
            p.setProperty("UTF-8", ConstVal.UTF8);
            p.setProperty("resource.default_encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.velocityEngine = new VelocityEngine(p);
        }
        this.setConfigBuilder(configBuilder);
        configBuilder.setInjectionConfig((InjectionConfig)new VueInjectionConfig(configBuilder, this.properties){

            @Override
            public void initTableMap(TableInfo tableInfo) {
                super.initTableMap(tableInfo);
                String serviceName = tableInfo.getServiceName();
                this.getMap().put("moduleName", LowCodeUtil.getModuleName(tableInfo.getComment()));
                this.getMap().put("serviceName", LowCodeUtil.firstLowerServiceName(serviceName));
            }

            @Override
            public IFileCreate getFileCreate() {
                return (configBuilder, fileType, filePath) -> true;
            }
        });
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        TableInfo tableInfo = (TableInfo)objectMap.get("table");
        try (StringWriter sw = new StringWriter();){
            template.merge((Context)new VelocityContext(objectMap), (Writer)sw);
            if (outputFile.endsWith(".vue")) {
                this.reviewDto.setHtml(sw.toString());
            } else if (outputFile.contains(tableInfo.getXmlName()) && outputFile.endsWith(".xml")) {
                this.reviewDto.setMapperXml(sw.toString());
            } else if (outputFile.contains(tableInfo.getMapperName()) && outputFile.endsWith(".java")) {
                this.reviewDto.setMapper(sw.toString());
            } else if (outputFile.contains(tableInfo.getServiceName())) {
                this.reviewDto.setService(sw.toString());
            } else if (outputFile.contains(tableInfo.getServiceImplName())) {
                this.reviewDto.setServiceImpl(sw.toString());
            } else if (outputFile.contains(tableInfo.getControllerName())) {
                this.reviewDto.setController(sw.toString());
            } else if (outputFile.contains(tableInfo.getEntityName())) {
                this.reviewDto.setEntity(sw.toString());
            }
        }
    }

    public ReviewDto getReviewDto() {
        return this.reviewDto;
    }

    public void setReviewDto(ReviewDto reviewDto) {
        this.reviewDto = reviewDto;
    }
}

