/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.spi.auth;

import com.iteaj.framework.autoconfigure.FrameworkProperties;
import com.iteaj.framework.spi.auth.AuthContext;
import com.iteaj.framework.spi.auth.SecurityException;
import com.iteaj.framework.spi.auth.WebAuthAction;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface WebAuthHandler {
    public FrameworkProperties getConfig();

    public WebAuthAction getAction(String var1);

    public List<WebAuthAction> getActions();

    public WebAuthAction matcher(HttpServletRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void login(HttpServletRequest request, HttpServletResponse response) throws SecurityException {
        WebAuthAction action = this.matcher(request);
        if (action != null) {
            Exception throwable = null;
            AuthContext context = action.getContext(request, response);
            try {
                action.login(context, request, response);
            }
            catch (Exception e) {
                throwable = e;
            }
            finally {
                action.loginCall(throwable, request, response);
            }
        }
    }

    default public void logout(HttpServletRequest request, HttpServletResponse response) {
        WebAuthAction matcher = this.matcher(request);
        if (matcher != null) {
            matcher.logout(request, response);
        }
    }

    default public AuthContext getAuthContext(HttpServletRequest request) {
        return (AuthContext)request.getAttribute("SESSION_AUTH_CONTEXT");
    }

    default public boolean preAuthorize(HttpServletRequest request, HttpServletResponse response) {
        WebAuthAction action = this.matcher(request);
        if (action == null) {
            return true;
        }
        AuthContext context = action.getContext(request, response);
        context.setAction(action.getName());
        request.setAttribute("SESSION_AUTH_CONTEXT", (Object)context);
        return action.preAuthorize(request, response);
    }

    default public boolean postAuthorize(HttpServletRequest request, HttpServletResponse response) throws SecurityException {
        WebAuthAction action = this.matcher(request);
        if (action == null) {
            request.setAttribute("EXEC_EXCEPTION_STATUS", (Object)"\u672a\u8ba4\u8bc1");
            return true;
        }
        boolean authorize = action.postAuthorize(request, response);
        if (authorize) {
            request.setAttribute("EXEC_EXCEPTION_STATUS", (Object)"\u672a\u8ba4\u8bc1");
        }
        return authorize;
    }
}

