/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.security.shiro.online;

import com.iteaj.framework.autoconfigure.FrameworkProperties;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.BrowserType;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.Serializable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;

public class OnlineSessionManager
extends DefaultWebSessionManager {
    private FrameworkProperties properties;

    public OnlineSessionManager(FrameworkProperties frameworkProperties) {
        this.properties = frameworkProperties;
    }

    protected Serializable getSessionId(ServletRequest request, ServletResponse response) {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        UserAgent userAgent = UserAgent.parseUserAgentString((String)servletRequest.getHeader("user-agent"));
        servletRequest.setAttribute("WEB_USER_AGENT", (Object)userAgent);
        Browser browser = userAgent.getBrowser();
        if (browser != null && browser.getBrowserType() == BrowserType.APP) {
            String tokenName = this.properties.getAuth().getTokenName();
            return servletRequest.getHeader(tokenName);
        }
        return super.getSessionId(request, response);
    }

    public boolean isServletContainerSessions() {
        return false;
    }
}

