/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.mybatis.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iteaj.util.CommonUtils;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={ArrayNode.class, ObjectNode.class, ContainerNode.class})
@MappedJdbcTypes(value={JdbcType.CHAR, JdbcType.VARCHAR})
public class JacksonTypeHandler
extends BaseTypeHandler<ContainerNode> {
    private static ObjectMapper mapper = new ObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(JacksonTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, ContainerNode parameter, JdbcType jdbcType) throws SQLException {
        if (parameter != null) {
            try {
                String json = mapper.writeValueAsString((Object)parameter);
                ps.setString(i, json);
            }
            catch (JsonProcessingException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public ContainerNode getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String string = rs.getString(columnName);
        if (CommonUtils.isNotBlank((String)string)) {
            try {
                return (ContainerNode)mapper.readValue(string, ContainerNode.class);
            }
            catch (IOException e) {
                logger.error("\u9519\u8bef\u7684json\u683c\u5f0f: {}", (Object)string, (Object)e);
                return null;
            }
        }
        return null;
    }

    public ContainerNode getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String string = rs.getString(columnIndex);
        if (null != string) {
            try {
                return (ContainerNode)mapper.readValue(string, ContainerNode.class);
            }
            catch (IOException e) {
                logger.error("\u9519\u8bef\u7684json\u683c\u5f0f: {}", (Object)string, (Object)e);
                return null;
            }
        }
        return null;
    }

    public ContainerNode getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return null;
    }
}

