/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.quartz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.BooleanResult;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.result.PageResult;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.quartz.entity.JobTask;
import com.iteaj.iboot.msn.quartz.jobs.SpringSupportJob;
import com.iteaj.iboot.msn.quartz.scheduler.SchedulerManager;
import com.iteaj.iboot.msn.quartz.service.IJobTaskService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/quartz/task"})
public class JobTaskController
extends BaseController {
    private final IJobTaskService jobTaskService;
    private final SpringSupportJob springSupportJob;
    private final SchedulerManager schedulerManager;

    public JobTaskController(IJobTaskService jobTaskService, SpringSupportJob springSupportJob, SchedulerManager schedulerManager) {
        this.jobTaskService = jobTaskService;
        this.springSupportJob = springSupportJob;
        this.schedulerManager = schedulerManager;
    }

    @GetMapping(value={"view"})
    public PageResult<Page<JobTask>> view(Page page, JobTask entity) {
        return this.jobTaskService.page((IPage)page, (Entity)entity);
    }

    @GetMapping(value={"detail"})
    public DetailResult<JobTask> detail(Long id) {
        return this.jobTaskService.getById((Serializable)id);
    }

    @PostMapping(value={"addOrUpdate"})
    public BooleanResult addOrUpdate(@RequestBody JobTask entity) {
        return this.jobTaskService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"del"})
    public BooleanResult del(@RequestBody List<Long> ids) {
        return this.jobTaskService.removeByIds(ids);
    }

    @PostMapping(value={"/status/{status}"})
    public Result<Object> status(@PathVariable String status, @RequestBody JobTask entity) {
        if ("paused".equals(status)) {
            this.schedulerManager.pauseJob(entity.getJobName());
        } else if ("resume".equals(status)) {
            this.schedulerManager.resumeJob(entity.getJobName());
        } else {
            return this.fail("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
        }
        return this.success("\u4fee\u6539\u72b6\u6001\u6210\u529f");
    }

    @PostMapping(value={"once"})
    public Result once(@RequestBody JobTask entity) {
        this.schedulerManager.fireJob(entity.getJobName());
        return this.success("\u89e6\u53d1\u6210\u529f");
    }

    @GetMapping(value={"taskMethods"})
    public Result<List<Map<String, String>>> taskMethods() {
        return this.success((Object)this.springSupportJob.getOptionValues());
    }
}

