/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.dto.SignalOfModelDto;
import com.iteaj.iboot.msn.iot.entity.Signal;
import com.iteaj.iboot.msn.iot.service.ISignalService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/signal"})
public class SignalController
extends BaseController {
    private final ISignalService signalService;

    public SignalController(ISignalService signalService) {
        this.signalService = signalService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:signal:view"})
    public Result<IPage<Signal>> list(Page<Signal> page, Signal entity) {
        return this.signalService.detailByPage(page, entity);
    }

    @GetMapping(value={"/listByModel"})
    public Result<List<SignalOfModelDto>> listByModel(Integer modelId) {
        List modelDtos = this.signalService.list((Entity)new Signal(modelId)).stream().map(item -> new SignalOfModelDto().setId(item.getId().toString()).setName(item.getName()).setAddress(item.getAddress()).setFieldName(item.getFieldName())).collect(Collectors.toList());
        return this.success(modelDtos);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:signal:edit"})
    public Result<Signal> getById(Long id) {
        return this.signalService.getById((Serializable)id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:signal:edit", "iot:signal:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody Signal entity) {
        return this.signalService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:signal:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.signalService.removeByIds(idList);
    }
}

