/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.consts.DeviceTypeAlias;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.Device;
import com.iteaj.iboot.msn.iot.service.IDeviceService;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/dtu"})
public class DeviceDtuController
extends BaseController {
    private final IDeviceService deviceService;

    public DeviceDtuController(IDeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:dtu:view"})
    public Result<IPage<DeviceDto>> list(Page<Device> page, DeviceDto entity) {
        entity.setAlias(DeviceTypeAlias.DTU);
        return this.deviceService.pageOfDetail(page, entity);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:dtu:edit"})
    public Result<Device> getEditDetail(Long id) {
        return this.deviceService.getById((Serializable)id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:dtu:edit", "iot:dtu:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody Device entity) {
        return this.deviceService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:dtu:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.deviceService.removeByIds(idList);
    }
}

