/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.collect.CollectActionFactory;
import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.CollectOption;
import com.iteaj.iboot.msn.iot.collect.CollectService;
import com.iteaj.iboot.msn.iot.collect.store.StoreActionFactory;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.entity.CollectTask;
import com.iteaj.iboot.msn.iot.service.ICollectTaskService;
import java.util.List;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/collectTask"})
public class CollectTaskController
extends BaseController {
    private final CollectService collectService;
    private final ICollectTaskService collectTaskService;
    private final StoreActionFactory storeActionFactory;
    private final CollectActionFactory collectActionFactory;

    public CollectTaskController(CollectService collectService, ICollectTaskService collectTaskService, StoreActionFactory storeActionFactory, CollectActionFactory collectActionFactory) {
        this.collectService = collectService;
        this.collectTaskService = collectTaskService;
        this.storeActionFactory = storeActionFactory;
        this.collectActionFactory = collectActionFactory;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:collectTask:view"})
    public Result<IPage<CollectTaskDto>> list(Page<CollectTaskDto> page, CollectTaskDto entity) {
        return this.collectTaskService.detailOfPage(page, entity);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:collectTask:edit"})
    public Result<CollectTaskDto> getById(Long id) {
        return this.collectTaskService.detailById(id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:collectTask:edit", "iot:collectTask:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody CollectTask entity) {
        if (entity.getStatus() != null && entity.getStatus().equals("run")) {
            return this.fail("\u8bf7\u5148\u505c\u6b62\u4efb\u52a1\u540e\u5728\u66f4\u65b0");
        }
        try {
            CronExpression.parse((String)entity.getCron());
        }
        catch (Exception e) {
            return this.fail("\u4efb\u52a1\u8c03\u5ea6\u8868\u8fbe\u5f0f\u9519\u8bef");
        }
        return this.collectTaskService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:collectTask:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.collectTaskService.removeByIds(idList);
    }

    @PostMapping(value={"/status"})
    @RequiresPermissions(value={"iot:collectTask:status"})
    public Result<Boolean> status(@RequestBody CollectTask entity) {
        try {
            this.collectService.statusSwitch(entity.getId(), entity.getStatus());
        }
        catch (CollectException e) {
            return Result.fail((String)e.getMessage());
        }
        return this.success();
    }

    @GetMapping(value={"collectActions"})
    public Result<List<CollectOption>> collectActions() {
        return this.success((Object)this.collectActionFactory.options());
    }

    @GetMapping(value={"storeActions"})
    public Result<List<CollectOption>> storeActions() {
        return this.success((Object)this.storeActionFactory.options());
    }
}

