/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.action;

import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.CollectAction;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.entity.Signal;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.plc.omron.OmronConnectProperties;
import com.iteaj.iot.plc.omron.OmronTcpProtocol;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public class OmronCollectAction
extends CollectAction {
    public String getName() {
        return "PLC:OMRON";
    }

    public String getDesc() {
        return "\u6b27\u59c6\u9f99PLC\u91c7\u96c6\u5668";
    }

    public void validate(Signal signal) {
        super.validate(signal);
    }

    public void validate(CollectDetail detail) {
        super.validate(detail);
        DeviceDto device = detail.getDevice();
        if (StringUtils.hasText((String)device.getIp()) || device.getPort() == null) {
            throw new CollectException("\u6b27\u59c6\u9f99\u8bbe\u5907[" + device.getDeviceSn() + "]\u6ca1\u6709\u6307\u5b9aip\u6216\u8005\u7aef\u53e3\u53f7");
        }
    }

    protected void doExec(CollectTaskDto taskDto, CollectDetail detail, Signal signal, Consumer<String> call) {
        Object value = "";
        String address = signal.getAddress();
        DeviceDto device = detail.getDevice();
        OmronTcpProtocol protocol = new OmronTcpProtocol(new OmronConnectProperties(device.getIp(), device.getPort()));
        Integer fieldType = signal.getFieldType();
        switch (fieldType) {
            case 1: {
                break;
            }
            case 2: {
                value = protocol.readInt16(address);
                break;
            }
            case 3: {
                value = protocol.readInt32(address);
                break;
            }
            case 4: {
                value = protocol.readInt64(address);
                break;
            }
            case 5: {
                value = protocol.readFloat(address);
                break;
            }
            case 6: {
                value = protocol.readDouble(address);
                break;
            }
            case 7: {
                value = protocol.readBool(address);
            }
        }
        if (protocol.getExecStatus() != ExecStatus.success) {
            throw new CollectException(protocol.getExecStatus().desc);
        }
        call.accept(value.toString());
    }
}

