/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.action;

import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.AbstractModbusCollectAction;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.entity.Signal;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.modbus.ModbusCommonProtocol;
import com.iteaj.iot.modbus.Payload;
import com.iteaj.iot.modbus.client.tcp.ModbusTcpClientCommonProtocol;
import com.iteaj.iot.modbus.client.tcp.ModbusTcpClientMessage;
import com.iteaj.iot.modbus.server.tcp.ModbusTcpBody;
import com.iteaj.iot.utils.ByteUtil;
import java.util.function.Consumer;

public class ModbusTcpClientCollectAction
extends AbstractModbusCollectAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doExec(CollectTaskDto taskDto, CollectDetail detail, Signal signal, Consumer<String> call) {
        Object value;
        Integer type = signal.getFieldType();
        DeviceDto device = detail.getDevice();
        Integer childSn = Integer.valueOf(detail.getChildSn());
        Integer address = Integer.valueOf(signal.getAddress());
        if (address > 40001) {
            address = address - 40001;
        }
        if (type == 7) {
            address = address - 1;
        }
        ModbusTcpClientCommonProtocol syncProtocol = (ModbusTcpClientCommonProtocol)this.getModbusCommonProtocol(type, device.getDeviceSn(), childSn, address, signal.getNum());
        try {
            syncProtocol.sync(3000L).request(new ClientConnectProperties(device.getIp(), device.getPort(), device.getDeviceSn()));
        }
        catch (ProtocolException e) {
            throw new CollectException(e.getMessage());
        }
        if (syncProtocol.getExecStatus() != ExecStatus.success) throw new CollectException(syncProtocol.getExecStatus().desc);
        ModbusTcpBody body = ((ModbusTcpClientMessage)syncProtocol.responseMessage()).getBody();
        if (!body.isSuccess()) throw new CollectException(body.getErrCode().getDesc());
        Payload payload = syncProtocol.getPayload();
        switch (type) {
            case 7: {
                value = payload.readBoolean(address.intValue());
                break;
            }
            case 2: {
                value = payload.readShort(address.intValue());
                break;
            }
            case 3: {
                value = payload.readInt(address.intValue());
                break;
            }
            case 5: {
                value = Float.valueOf(payload.readFloat(address.intValue()));
                break;
            }
            case 6: {
                value = payload.readDouble(address.intValue());
                break;
            }
            case 4: {
                value = payload.readLong(address.intValue());
                break;
            }
            case 9: {
                value = payload.readString(address.intValue(), signal.getNum().intValue());
                break;
            }
            default: {
                value = ByteUtil.bytesToHex((byte[])payload.getPayload());
            }
        }
        call.accept(value.toString());
    }

    protected ModbusCommonProtocol getModbusCommonProtocol(Integer type, String deviceSn, Integer childSn, Integer address, Integer num) {
        switch (type) {
            case 7: {
                return ModbusTcpClientCommonProtocol.buildRead01((int)childSn, (int)address, (int)1);
            }
            case 2: {
                return ModbusTcpClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)1);
            }
            case 3: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                return ModbusTcpClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)2);
            }
            case 4: 
            case 6: {
                return ModbusTcpClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)4);
            }
        }
        return ModbusTcpClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)num);
    }

    public String getName() {
        return "CLIENT:MODBUS:TCP";
    }

    public String getDesc() {
        return "ModbusTcp\u91c7\u96c6\u5668";
    }
}

