/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.action;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.AbstractModbusCollectAction;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.entity.Serial;
import com.iteaj.iboot.msn.iot.entity.Signal;
import com.iteaj.iboot.msn.iot.rtu.ModbusRtuClientCommonProtocol;
import com.iteaj.iboot.msn.iot.service.ISerialService;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.modbus.Payload;
import com.iteaj.iot.modbus.client.rtu.ModbusRtuClientMessage;
import com.iteaj.iot.modbus.server.rtu.ModbusRtuBody;
import com.iteaj.iot.serial.SerialConnectProperties;
import java.util.HashMap;
import java.util.function.Consumer;

public class ModbusRtuClientCollectAction
extends AbstractModbusCollectAction {
    private final ISerialService serialService;

    public ModbusRtuClientCollectAction(ISerialService serialService) {
        this.serialService = serialService;
    }

    public void validate(CollectDetail detail) {
        super.validate(detail);
        String deviceSn = detail.getDevice().getDeviceSn();
        Serial serial = (Serial)this.serialService.getOne((Wrapper)Wrappers.lambdaQuery().eq(Serial::getCom, (Object)deviceSn)).ofNullable().orElseThrow(() -> new CollectException("\u4e32\u53e3\u4e0d\u5b58\u5728[" + deviceSn + "]"));
        if (detail.getParams() == null) {
            detail.setParams(new HashMap());
            detail.getParams().put("serial", serial);
        }
    }

    protected void doExec(CollectTaskDto taskDto, CollectDetail detail, Signal signal, Consumer<String> call) {
        Integer type = signal.getFieldType();
        DeviceDto device = detail.getDevice();
        Integer childSn = Integer.valueOf(detail.getChildSn());
        Integer address = Integer.valueOf(signal.getAddress());
        if (address > 40001) {
            address = address - 40001;
        }
        if (type == 7) {
            address = address - 1;
        }
        ModbusRtuClientCommonProtocol syncProtocol = this.getModbusCommonProtocol(type, device.getDeviceSn(), childSn, address, signal.getNum());
        try {
            Serial serial = (Serial)detail.getParams().get("serial");
            SerialConnectProperties config = new SerialConnectProperties(serial.getCom(), serial.getBaudRate().intValue()).config(serial.getDataBits().intValue(), serial.getStopBits().intValue(), serial.getParity().intValue());
            syncProtocol.sync(3000L).request((ClientConnectProperties)config);
        }
        catch (ProtocolException e) {
            throw new CollectException(e.getMessage());
        }
        if (syncProtocol.getExecStatus() == ExecStatus.success) {
            ModbusRtuBody body = ((ModbusRtuClientMessage)syncProtocol.responseMessage()).getBody();
            if (!body.isSuccess()) {
                throw new CollectException(body.getErrCode().getDesc());
            }
        } else {
            throw new CollectException(syncProtocol.getExecStatus().desc);
        }
        Payload payload = syncProtocol.getPayload();
        Object resolveValue = this.resolveValue(signal.getNum(), type, address, payload);
        call.accept(resolveValue.toString());
    }

    protected ModbusRtuClientCommonProtocol getModbusCommonProtocol(Integer type, String deviceSn, Integer childSn, Integer address, Integer num) {
        switch (type) {
            case 7: {
                return ModbusRtuClientCommonProtocol.buildRead01((int)childSn, (int)address, (int)1);
            }
            case 2: {
                return ModbusRtuClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)1);
            }
            case 3: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                return ModbusRtuClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)2);
            }
            case 4: 
            case 6: {
                return ModbusRtuClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)4);
            }
        }
        return ModbusRtuClientCommonProtocol.buildRead03((int)childSn, (int)address, (int)num);
    }

    public String getName() {
        return "CLIENT:MODBUS:RTU";
    }

    public String getDesc() {
        return "ModbusRtu\u91c7\u96c6\u5668";
    }
}

