/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect;

import com.iteaj.iboot.msn.iot.collect.CollectActionFactory;
import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.CollectAction;
import com.iteaj.iboot.msn.iot.collect.store.StoreAction;
import com.iteaj.iboot.msn.iot.collect.store.StoreActionFactory;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.entity.CollectData;
import com.iteaj.iot.utils.UniqueIdGen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CollectActionTask
implements Runnable {
    private CollectTaskDto taskDto;
    private Logger logger = LoggerFactory.getLogger((String)"IOT:DATA:COLLECT");

    public CollectActionTask(CollectTaskDto taskDto) {
        this.taskDto = taskDto;
    }

    @Override
    public void run() {
        if (this.taskDto != null && !CollectionUtils.isEmpty((Collection)this.taskDto.getDetails())) {
            Date date = new Date();
            long cid = UniqueIdGen.nextLong();
            this.taskDto.getDetails().forEach(item -> {
                StoreAction storeAction;
                ArrayList values = new ArrayList();
                CollectAction action = CollectActionFactory.getInstance().get(item.getCollectAction());
                if (action != null) {
                    item.getSignals().forEach(signal -> {
                        CollectData data = new CollectData().setCid(Long.valueOf(cid)).setReason("").setStatus(Boolean.valueOf(false)).setCreateTime(date).setUid(item.getUid()).setSignalId(signal.getId()).setCollectTaskId(this.taskDto.getId());
                        try {
                            data.setAddress(signal.getAddress());
                            data.setFieldType(signal.getFieldType());
                            action.exec(this.taskDto, item, signal, value -> data.setValue(value).setCollectTime(new Date()).setStatus(Boolean.valueOf(true)));
                        }
                        catch (CollectException e) {
                            data.setStatus(Boolean.valueOf(false)).setCollectTime(new Date()).setReason(e.getMessage());
                            this.logger.error("\u91c7\u96c6\u4efb\u52a1\u5931\u8d25 \u63a5\u53e3\u8c03\u7528\u5f02\u5e38 - \u4efb\u52a1: {} - \u5468\u671f: {} - \u8bbe\u5907: {}({}) - \u70b9\u4f4d: {}({})", new Object[]{e.getMessage(), this.taskDto.getName(), this.taskDto.getCron(), item.getDevice().getName(), item.getDevice().getUid(), signal.getName(), signal.getAddress(), e});
                        }
                        catch (Exception e) {
                            data.setStatus(Boolean.valueOf(false)).setCollectTime(new Date()).setReason("\u672a\u77e5\u9519\u8bef");
                            this.logger.error("\u91c7\u96c6\u4efb\u52a1\u5931\u8d25 \u63a5\u53e3\u8c03\u7528\u5f02\u5e38 - \u4efb\u52a1: {} - \u5468\u671f: {} - \u8bbe\u5907: {}({}) - \u70b9\u4f4d: {}({})", new Object[]{e.getMessage(), this.taskDto.getName(), this.taskDto.getCron(), item.getDevice().getName(), item.getDevice().getUid(), signal.getName(), signal.getAddress(), e});
                        }
                        values.add(data);
                    });
                }
                if (!CollectionUtils.isEmpty(values) && (storeAction = StoreActionFactory.getInstance().get(item.getStoreAction())) != null) {
                    storeAction.store(item, values);
                }
            });
        } else {
            this.logger.error("\u91c7\u96c6\u4efb\u52a1\u5931\u8d25 \u4efb\u52a1\u4e0d\u5b58\u5728");
        }
    }

    public CollectTaskDto getTaskDto() {
        return this.taskDto;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setTaskDto(CollectTaskDto taskDto) {
        this.taskDto = taskDto;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectActionTask)) {
            return false;
        }
        CollectActionTask other = (CollectActionTask)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CollectTaskDto this$taskDto = this.getTaskDto();
        CollectTaskDto other$taskDto = other.getTaskDto();
        if (this$taskDto == null ? other$taskDto != null : !this$taskDto.equals(other$taskDto)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectActionTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CollectTaskDto $taskDto = this.getTaskDto();
        result = result * 59 + ($taskDto == null ? 43 : $taskDto.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public String toString() {
        return "CollectActionTask(taskDto=" + this.getTaskDto() + ", logger=" + this.getLogger() + ")";
    }
}

