/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect;

import com.iteaj.iboot.msn.iot.collect.CollectOption;
import com.iteaj.iboot.msn.iot.collect.action.CollectAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CollectActionFactory
implements InitializingBean {
    @Autowired(required=false)
    private List<CollectAction> actions;
    private Map<String, CollectAction> actionMap = new ConcurrentHashMap(8);
    private static CollectActionFactory actionFactory = new CollectActionFactory();

    protected CollectActionFactory() {
    }

    public static CollectActionFactory getInstance() {
        return actionFactory;
    }

    public CollectAction get(String actionName) {
        if (!StringUtils.hasText((String)actionName)) {
            return null;
        }
        return (CollectAction)this.actionMap.get(actionName);
    }

    public Set<String> getNames() {
        return this.actionMap.keySet();
    }

    public Collection<CollectAction> getActions() {
        return this.actionMap.values();
    }

    public boolean isExists(String actionName) {
        return this.actionMap.containsKey(actionName);
    }

    public CollectAction remove(String actionName) {
        return (CollectAction)this.actionMap.remove(actionName);
    }

    public CollectAction register(String actionName, CollectAction collectAction) {
        return this.actionMap.putIfAbsent(actionName, collectAction);
    }

    public CollectAction register(CollectAction collectAction) {
        return this.actionMap.putIfAbsent(collectAction.getName(), collectAction);
    }

    public List<CollectOption> options() {
        return this.actionMap.values().stream().map(item -> new CollectOption(item.getDesc(), item.getName())).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty((Collection)this.actions)) {
            this.actions.forEach(item -> {
                if (this.isExists(item.getName())) {
                    throw new BeanInitializationException("\u5b58\u5728\u76f8\u540c\u7684\u91c7\u96c6\u52a8\u4f5c[" + item.getName() + "]");
                }
                this.register(item);
            });
        }
    }
}

