/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iteaj.framework.BaseServiceImpl;
import com.iteaj.framework.Entity;
import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.result.BooleanResult;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.result.ListResult;
import com.iteaj.framework.utils.TreeUtils;
import com.iteaj.iboot.msn.core.entity.Org;
import com.iteaj.iboot.msn.core.mapper.IOrgDao;
import com.iteaj.iboot.msn.core.service.IAdminService;
import com.iteaj.iboot.msn.core.service.IOrgService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"IBOOT:ORG"})
public class OrgServiceImpl
extends BaseServiceImpl<IOrgDao, Org>
implements IOrgService {
    private final IAdminService adminService;

    @CacheEvict(allEntries=true)
    public BooleanResult save(Org entity) {
        BooleanResult booleanResult = super.save((Entity)entity);
        if (entity.getPid() == 0L) {
            entity.setLevel(Integer.valueOf(1));
            entity.setPath(entity.getId().toString());
        } else if (entity.getPid() > 0L) {
            DetailResult parent = this.getById((Serializable)entity.getPid());
            parent.ofNullable().orElseThrow(() -> new ServiceException("\u7236\u90e8\u95e8\u4e0d\u5b58\u5728"));
            entity.setLevel(Integer.valueOf(((Org)parent.getData()).getLevel() + 1));
            entity.setPath(((Org)parent.getData()).getPath() + "," + entity.getId());
            this.updateById(entity);
        }
        return booleanResult;
    }

    @CacheEvict(allEntries=true)
    public BooleanResult updateById(Org entity) {
        if (entity.getPid() > 0L) {
            DetailResult parent = this.getById((Serializable)entity.getPid());
            parent.ofNullable().orElseThrow(() -> new ServiceException("\u7236\u90e8\u95e8\u4e0d\u5b58\u5728"));
            entity.setLevel(Integer.valueOf(((Org)parent.getData()).getLevel() + 1));
            entity.setPath(((Org)parent.getData()).getPath() + "," + entity.getId());
            if (((Org)parent.getData()).getPid() == entity.getId()) {
                throw new ServiceException("\u7236\u90e8\u95e8\u4e0d\u80fd\u662f\u81ea\u5df1");
            }
        }
        return super.updateById((Entity)entity);
    }

    @CacheEvict(allEntries=true)
    public BooleanResult removeByIds(Collection<? extends Serializable> idList) {
        if (idList.size() == 0) {
            throw new ServiceException("\u672a\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e");
        }
        if (idList.size() > 1) {
            throw new ServiceException("\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664");
        }
        Serializable id = idList.stream().findFirst().get();
        this.list((Wrapper)Wrappers.query().eq((Object)"pid", (Object)id)).ofNullable().ifPresent(item -> {
            if (!item.isEmpty()) {
                throw new ServiceException("\u8bf7\u5148\u5220\u9664\u5b50\u90e8\u95e8");
            }
        });
        this.adminService.getOne((Wrapper)Wrappers.query().eq((Object)"org_id", (Object)id)).ofNullable().ifPresent(item -> {
            throw new ServiceException("\u6b64\u90e8\u95e8\u5df2\u88ab\u5173\u8054\u4f7f\u7528");
        });
        return super.removeByIds(idList);
    }

    public ListResult<Org> selectTrees(Org org) {
        ListResult selectList = this.list((Entity)org);
        return new ListResult((List)TreeUtils.toTrees((Collection)((Collection)selectList.getData()), (Long)0L));
    }

    @Cacheable(key="'list'")
    public ListResult<Org> list() {
        return super.list();
    }

    public OrgServiceImpl(IAdminService adminService) {
        this.adminService = adminService;
    }
}

