/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.BaseServiceImpl;
import com.iteaj.framework.Entity;
import com.iteaj.framework.TreeEntity;
import com.iteaj.framework.consts.PermStatus;
import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.result.BooleanResult;
import com.iteaj.framework.result.ListResult;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.framework.spi.admin.MenuType;
import com.iteaj.framework.utils.TreeUtils;
import com.iteaj.iboot.msn.core.entity.Menu;
import com.iteaj.iboot.msn.core.enums.Status;
import com.iteaj.iboot.msn.core.mapper.IMenuDao;
import com.iteaj.iboot.msn.core.service.IMenuService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MenuServiceImpl
extends BaseServiceImpl<IMenuDao, Menu>
implements IMenuService,
InitializingBean {
    private Map<Long, Menu> idMenuMap = new HashMap(128);
    private Map<String, Menu> loggerMenuCache = new HashMap(128);

    public BooleanResult save(Menu entity) {
        this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Menu::getName, (Object)entity.getName())).eq(TreeEntity::getPid, (Object)entity.getPid())).ofNullable().ifPresent(menu -> {
            throw new ServiceException("\u540c\u7ea7\u5df2\u7ecf\u5b58\u5728\u83dc\u5355\u540d\u79f0[" + entity.getName() + "]");
        });
        BooleanResult booleanResult = super.save((Entity)entity);
        this.syncMenuToCache();
        return booleanResult;
    }

    public BooleanResult updateById(Menu entity) {
        this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(BaseEntity::getId, (Object)entity.getId())).eq(TreeEntity::getPid, (Object)entity.getPid())).eq(Menu::getName, (Object)entity.getName())).ofNullable().ifPresent(menu -> {
            throw new ServiceException("\u540c\u7ea7\u5df2\u7ecf\u5b58\u5728\u83dc\u5355\u540d\u79f0[" + entity.getName() + "]");
        });
        BooleanResult booleanResult = super.updateById((Entity)entity);
        this.syncMenuToCache();
        return booleanResult;
    }

    public ListResult<Menu> selectMenuTrees(Menu menu) {
        List menuList = ((IMenuDao)this.getBaseMapper()).selectList((Wrapper)Wrappers.query((Object)menu).orderByAsc((Object)"sort"));
        List menus = (List)TreeUtils.toTrees((Collection)menuList, (Long)menu.getPid());
        return new ListResult(menus);
    }

    public ListResult<Menu> selectMenuBarTrees(Long aid, boolean isSuper) {
        List allMenus = ((IMenuDao)this.getBaseMapper()).selectList((Wrapper)((QueryWrapper)Wrappers.query().ne((Object)"status", (Object)PermStatus.disabled)).orderByAsc((Object)"sort"));
        if (CollectionUtils.isEmpty((Collection)allMenus)) {
            return new ListResult(Collections.emptyList());
        }
        if (isSuper) {
            List menus = (List)TreeUtils.toTrees((Collection)allMenus, (Long)0L);
            return new ListResult(menus);
        }
        List adminMenuIds = ((IMenuDao)this.getBaseMapper()).selectAdminMenus(aid);
        Collection menus = TreeUtils.toAdminMenuTrees((List)allMenus, (List)adminMenuIds);
        return new ListResult(menus.stream().collect(Collectors.toList()));
    }

    public ListResult selectParentTrees() {
        List status = ((IMenuDao)this.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(Menu::getType, (Object)MenuType.A)).ne(Menu::getStatus, (Object)PermStatus.disabled)).orderByAsc(Menu::getSort));
        List menus = (List)TreeUtils.toTrees((Collection)status, (Long)0L);
        return new ListResult(menus);
    }

    public BooleanResult removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new ServiceException("\u672a\u6307\u5b9a\u8981\u5220\u9664\u7684\u8bb0\u5f55");
        }
        if (idList.size() > 1) {
            throw new ServiceException("\u83dc\u5355\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664");
        }
        idList.stream().forEach(item -> this.count((Wrapper)Wrappers.query().eq((Object)"pid", item)).ofNullable().filter(count -> count > 0).ifPresent(menu -> {
            throw new ServiceException("\u8bf7\u5148\u5220\u9664\u5b50\u83dc\u5355");
        }));
        BooleanResult booleanResult = super.removeByIds(idList);
        this.syncMenuToCache();
        return booleanResult;
    }

    public Menu getByUrl(String url) {
        return (Menu)((IMenuDao)this.getBaseMapper()).selectOne((Wrapper)Wrappers.query().eq((Object)"url", (Object)url));
    }

    public Menu getByUrlFromCache(String url) {
        return (Menu)this.loggerMenuCache.get(url);
    }

    public Menu getByIdFromCache(Long id) {
        return (Menu)this.idMenuMap.get(id);
    }

    public List<String> selectPermissions(Long adminId) {
        if (ShiroUtil.isSuper((Long)adminId)) {
            return ((IMenuDao)this.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(Menu::getStatus, (Object)PermStatus.disabled)).ne(Menu::getType, (Object)MenuType.M)).stream().filter(item -> StringUtils.hasText((String)item.getPerms())).map(item -> item.getPerms()).collect(Collectors.toList());
        }
        return ((IMenuDao)this.getBaseMapper()).selectPermissions(adminId);
    }

    public void afterPropertiesSet() throws Exception {
        this.syncMenuToCache();
    }

    private void syncMenuToCache() {
        this.loggerMenuCache.clear();
        this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Menu::getType, (Object)MenuType.A)).eq(Menu::getStatus, (Object)Status.enabled)).stream().filter(item -> StringUtils.hasText((String)item.getUrl())).forEach(item -> {
            this.idMenuMap.put(item.getId(), item);
            this.loggerMenuCache.put(item.getUrl(), item);
        });
    }
}

