/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.service.impl;

import com.iteaj.framework.spi.excel.IExcelService;
import com.iteaj.iboot.msn.core.entity.Org;
import com.iteaj.iboot.msn.core.service.IDictDataService;
import com.iteaj.iboot.msn.core.service.IOrgService;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class ExcelServiceImpl
implements IExcelService {
    private final IOrgService orgService;
    private final IDictDataService dictDataService;
    private static final String ORG_CACHE = "ORG:CACHE";
    private static final String DICT_CACHE_TO_NAME = "DICT:CACHE:TO:VALUE";
    private static final String DICT_CACHE_TO_VALUE = "DICT:CACHE:TO:VALUE";

    public ExcelServiceImpl(IOrgService orgService, IDictDataService dictDataService) {
        this.orgService = orgService;
        this.dictDataService = dictDataService;
    }

    public String toDictName(String dictType, Serializable dictValue) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object attribute = attributes.getAttribute("DICT:CACHE:TO:VALUE", 0);
        if (attribute instanceof Map) {
            Map stringMap = (Map)((Map)attribute).get(dictType);
            return stringMap != null ? (String)stringMap.get(dictValue) : null;
        }
        HashMap map = new HashMap();
        this.dictDataService.list().forEach(item -> {
            HashMap<String, String> stringMap = (HashMap<String, String>)map.get(item.getType());
            if (stringMap == null) {
                stringMap = new HashMap<String, String>();
                map.put(item.getType(), stringMap);
            }
            stringMap.put(item.getValue(), item.getLabel());
        });
        attributes.setAttribute("DICT:CACHE:TO:VALUE", map, 0);
        Map stringMap = (Map)map.get(dictType);
        return stringMap != null ? (String)stringMap.get(dictValue) : null;
    }

    public Serializable toDictValue(String dictType, String dictName) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object attribute = attributes.getAttribute("DICT:CACHE:TO:VALUE", 0);
        if (attribute instanceof Map) {
            Map stringMap = (Map)((Map)attribute).get(dictType);
            return stringMap != null ? (Serializable)stringMap.get(dictName) : null;
        }
        HashMap map = new HashMap();
        this.dictDataService.list().forEach(item -> {
            HashMap<String, String> stringMap = (HashMap<String, String>)map.get(item.getType());
            if (stringMap == null) {
                stringMap = new HashMap<String, String>();
                map.put(item.getType(), stringMap);
            }
            stringMap.put(item.getValue(), item.getLabel());
        });
        attributes.setAttribute("DICT:CACHE:TO:VALUE", map, 0);
        Map stringMap = (Map)map.get(dictType);
        return stringMap != null ? (Serializable)stringMap.get(dictName) : null;
    }

    public String toOrgName(Serializable id) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object attribute = attributes.getAttribute(ORG_CACHE, 0);
        if (attribute instanceof List) {
            Org org = ((List)attribute).stream().filter(item -> item.getId().equals(id)).findFirst().get();
            return org != null ? org.getName() : null;
        }
        List data = this.orgService.list().ofNullable().orElse(Collections.emptyList());
        attributes.setAttribute(ORG_CACHE, data, 0);
        Org org = data.stream().filter(item -> item.getId().equals(id)).findFirst().get();
        return org != null ? org.getName() : null;
    }

    public Serializable toOrgValue(String name) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object attribute = attributes.getAttribute(ORG_CACHE, 0);
        if (attribute instanceof List) {
            Org org = ((List)attribute).stream().filter(item -> item.getName().equals(name)).findFirst().get();
            return org != null ? org.getId() : null;
        }
        List data = this.orgService.list().ofNullable().orElse(Collections.emptyList());
        attributes.setAttribute(ORG_CACHE, data, 0);
        Org org = data.stream().filter(item -> item.getName().equals(name)).findFirst().get();
        return org != null ? org.getId() : null;
    }
}

