/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.controller;

import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.core.entity.Org;
import com.iteaj.iboot.msn.core.service.IOrgService;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/core/org"})
public class OrgController
extends BaseController {
    private final IOrgService organizeService;

    public OrgController(IOrgService organizeService) {
        this.organizeService = organizeService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"core:org:view"})
    public Result<List<Org>> view(Org org) {
        return this.organizeService.selectTrees(org);
    }

    @ResponseBody
    @GetMapping(value={"/parent"})
    public Result<List<Org>> parent() {
        return this.organizeService.selectTrees(null);
    }

    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"core:org:add"})
    public Result<Boolean> add(@RequestBody Org org) {
        return this.organizeService.save((Entity)org);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"core:org:edit"})
    public Result<Org> edit(Integer id) {
        return this.organizeService.getById((Serializable)id);
    }

    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"core:org:edit"})
    public Result<Boolean> edit(@RequestBody Org org) {
        return this.organizeService.updateById((Entity)org);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"core:org:del"})
    public Result<Boolean> del(@RequestBody List<Long> list) {
        return this.organizeService.removeByIds(list);
    }
}

