/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.PageResult;
import com.iteaj.framework.result.Result;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.framework.spi.admin.event.OnlineStatus;
import com.iteaj.iboot.msn.core.entity.OnlineUser;
import com.iteaj.iboot.msn.core.service.IOnlineUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/core/online"})
public class OnlineUserController
extends BaseController {
    private final IOnlineUserService onlineUserService;

    public OnlineUserController(IOnlineUserService onlineUserService) {
        this.onlineUserService = onlineUserService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"core:online:view"})
    public Result<IPage<OnlineUser>> list(Page<OnlineUser> page, OnlineUser entity) {
        page.addOrder(new OrderItem[]{OrderItem.asc((String)"status"), OrderItem.desc((String)"login_time")});
        ArrayList updateToOffline = new ArrayList();
        PageResult result = this.onlineUserService.page(page, (Entity)entity);
        result.stream().filter(item -> item.getStatus() == OnlineStatus.Online).forEach(item -> {
            Session session = ShiroUtil.getSession((String)item.getSessionId());
            if (session == null) {
                item.setStatus(OnlineStatus.Offline);
                updateToOffline.add(item);
            }
        });
        this.onlineUserService.updateBatchById(updateToOffline);
        return result;
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"core:online:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        if (idList.size() == 1) {
            this.onlineUserService.getById((Serializable)idList.get(0)).ofNullable().ifPresent(item -> {
                if (item.getStatus() == OnlineStatus.Online && null == ShiroUtil.getSession((String)item.getSessionId())) {
                    throw new IllegalStateException("\u5ba2\u6237\u7aef\u5728\u7ebf, \u8bf7\u5148\u5254\u9664");
                }
            });
        } else {
            this.onlineUserService.listByIds(idList).forEach(item -> {
                if (item.getStatus() == OnlineStatus.Online) {
                    idList.remove(item.getId());
                }
            });
        }
        return this.onlineUserService.removeByIds(idList);
    }

    @PostMapping(value={"offline"})
    @RequiresPermissions(value={"core:online:offline"})
    public Result<Boolean> offline(@RequestBody OnlineUser entity, HttpSession session) {
        if (entity.getStatus() == OnlineStatus.Offline) {
            return this.fail("\u6b64\u7528\u6237\u4e0d\u5728\u7ebf");
        }
        String sessionId = session.getId();
        if (sessionId.equals(entity.getSessionId())) {
            return this.fail("\u4e0d\u5141\u8bb8\u4e0b\u7ebf\u81ea\u5df1");
        }
        try {
            ShiroUtil.offline((Object)entity.getSessionId());
        }
        catch (UnknownSessionException e) {
            this.onlineUserService.updateBySessionId(entity.setStatus(OnlineStatus.Offline));
        }
        return this.success("\u5254\u9664\u7528\u6237\u6210\u529f");
    }
}

