/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.controller;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.Entity;
import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.result.Result;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.framework.utils.ExcelExportParams;
import com.iteaj.framework.utils.ExcelUtils;
import com.iteaj.iboot.msn.core.dto.AdminDto;
import com.iteaj.iboot.msn.core.dto.PasswordDto;
import com.iteaj.iboot.msn.core.entity.Admin;
import com.iteaj.iboot.msn.core.service.IAdminService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/core/admin"})
public class AdminController
extends BaseController {
    private final IAdminService adminService;

    public AdminController(IAdminService adminService) {
        this.adminService = adminService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"core:admin:view"})
    public Result view(Page page, Admin admin) {
        return this.adminService.page((IPage)page, (Entity)admin);
    }

    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"core:admin:add"})
    public Result add(@RequestBody AdminDto admin) {
        this.adminService.createAdmin(admin);
        return this.success();
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"core:admin:edit"})
    public Result<AdminDto> edit(Long id) {
        return this.adminService.getAdminDetailById(id);
    }

    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"core:admin:edit"})
    public Result<Boolean> edit(@RequestBody AdminDto admin) {
        this.adminService.updateAdminAndRole(admin);
        return this.success((Object)true);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"core:admin:del"})
    public Result<Boolean> del(@RequestBody List<Long> list) {
        this.adminService.deleteAllJoinByIds(list);
        return this.success();
    }

    @PostMapping(value={"import"})
    public Result<String> excelImport(MultipartFile file) throws IOException {
        List admins = ExcelUtils.importExcel((MultipartFile)file, Admin.class, (ImportParams)new ImportParams());
        this.adminService.saveBatch((Collection)admins);
        return this.success("\u5bfc\u5165\u6210\u529f");
    }

    @GetMapping(value={"export"})
    public void excelExport(Page<Admin> page, Admin admin, HttpServletResponse response) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        this.adminService.page(page, (Entity)admin).ifPresent((a, b) -> {
            try {
                if (CollectionUtils.isEmpty((Collection)a.getRecords())) {
                    throw new ServiceException("\u672a\u6307\u5b9a\u8981\u5bfc\u51fa\u7684\u6570\u636e");
                }
                ExcelUtils.exportExcel((Collection)a.getRecords(), Admin.class, (ExportParams)new ExcelExportParams(), (OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
        });
    }

    @PostMapping(value={"/modUserInfo"})
    public Result modUserInfo(@RequestBody Admin admin) {
        BaseEntity principal = (BaseEntity)ShiroUtil.getUser();
        if (principal == null) {
            return this.fail("\u672a\u767b\u5f55");
        }
        admin.setId(principal.getId());
        this.adminService.updateCurrentUserInfo(admin);
        return this.success("\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"pwd"})
    @RequiresPermissions(value={"core:admin:pwd"})
    public Result updatePwd(@RequestBody PasswordDto passwordDto) {
        this.adminService.setAdminPassword(passwordDto.getId(), passwordDto.getPassword());
        return this.success("\u8bbe\u7f6e\u6210\u529f");
    }
}

