/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot;

import com.iteaj.iboot.msn.iot.collect.CollectActionFactory;
import com.iteaj.iboot.msn.iot.collect.action.CommonDtuCollectAction;
import com.iteaj.iboot.msn.iot.collect.action.ModbusRtuClientCollectAction;
import com.iteaj.iboot.msn.iot.collect.action.ModbusRtuForDTUCollectAction;
import com.iteaj.iboot.msn.iot.collect.action.ModbusTcpClientCollectAction;
import com.iteaj.iboot.msn.iot.collect.action.ModbusTcpForDTUCollectAction;
import com.iteaj.iboot.msn.iot.collect.action.OmronCollectAction;
import com.iteaj.iboot.msn.iot.collect.action.SiemensCollectAction;
import com.iteaj.iboot.msn.iot.collect.store.MqttStoreAction;
import com.iteaj.iboot.msn.iot.collect.store.RDBMStoreAction;
import com.iteaj.iboot.msn.iot.collect.store.StoreActionFactory;
import com.iteaj.iboot.msn.iot.service.ISerialService;
import com.iteaj.iot.client.mqtt.gateway.MqttGatewayComponent;
import com.iteaj.iot.client.mqtt.impl.DefaultMqttComponent;
import com.iteaj.iot.config.ConnectProperties;
import com.iteaj.iot.modbus.client.tcp.ModbusTcpClientComponent;
import com.iteaj.iot.modbus.server.dtu.ModbusRtuForDtuServerComponent;
import com.iteaj.iot.modbus.server.dtu.ModbusTcpForDtuServerComponent;
import com.iteaj.iot.plc.omron.OmronComponent;
import com.iteaj.iot.plc.siemens.SiemensS7Component;
import com.iteaj.iot.serial.SerialComponent;
import com.iteaj.iot.server.dtu.impl.CommonDtuServerComponent;
import com.iteaj.iot.tools.db.rdbms.RdbmsSqlManager;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;

@Profile(value={"iot"})
@ComponentScan(value={"com.iteaj.iboot.msn.iot"})
@MapperScan(value={"com.iteaj.iboot.msn.iot.mapper"})
@AutoConfigureAfter(value={JdbcTemplateAutoConfiguration.class})
public class IotAutoConfiguration {
    @Bean
    public ModbusRtuForDtuServerComponent modbusRtuForDtuServerComponent() {
        return new ModbusRtuForDtuServerComponent(new ConnectProperties(Integer.valueOf(10000), 90L, 0L, 0L));
    }

    @Bean
    public ModbusTcpForDtuServerComponent modbusTcpForDtuServerComponent() {
        return new ModbusTcpForDtuServerComponent(new ConnectProperties(Integer.valueOf(7068), 90L, 0L, 0L));
    }

    @Bean
    public ModbusTcpClientComponent modbusTcpClientComponent() {
        return new ModbusTcpClientComponent();
    }

    @Bean
    public ModbusTcpClientCollectAction modbusTcpClientCollectAction() {
        return new ModbusTcpClientCollectAction();
    }

    @Bean
    public ModbusRtuClientCollectAction modbusRtuClientCollectAction(ISerialService serialService) {
        return new ModbusRtuClientCollectAction(serialService);
    }

    @Bean
    public CommonDtuServerComponent commonDtuServerComponent() {
        return new CommonDtuServerComponent(new ConnectProperties(Integer.valueOf(7078), 90L, 0L, 0L));
    }

    @Bean
    public SiemensS7Component siemensS7Component() {
        return new SiemensS7Component();
    }

    @Bean
    public OmronComponent omronComponent() {
        return new OmronComponent();
    }

    @Bean
    @ConditionalOnBean(value={OmronComponent.class})
    public OmronCollectAction omronCollectAction() {
        return new OmronCollectAction();
    }

    @Bean
    @ConditionalOnBean(value={SiemensS7Component.class})
    public SiemensCollectAction siemensCollectAction() {
        return new SiemensCollectAction();
    }

    @Bean
    public SerialComponent serialComponent() {
        return SerialComponent.instance();
    }

    @Bean
    @ConditionalOnBean(value={ModbusRtuForDtuServerComponent.class})
    public ModbusRtuForDTUCollectAction modbusRtuForDTUCollectAction() {
        return new ModbusRtuForDTUCollectAction();
    }

    @Bean
    @ConditionalOnBean(value={ModbusTcpForDtuServerComponent.class})
    public ModbusTcpForDTUCollectAction modbusTcpForDTUCollectAction() {
        return new ModbusTcpForDTUCollectAction();
    }

    @Bean
    @ConditionalOnBean(value={CommonDtuServerComponent.class})
    public CommonDtuCollectAction commonDtuCollectAction() {
        return new CommonDtuCollectAction();
    }

    @Bean
    public CollectActionFactory collectActionFactory() {
        return CollectActionFactory.getInstance();
    }

    @Bean
    @ConditionalOnBean(value={JdbcTemplate.class})
    public RdbmsSqlManager rdbmsSqlManager(JdbcTemplate jdbcTemplate) {
        return new RdbmsSqlManager(jdbcTemplate);
    }

    @Bean
    @ConditionalOnBean(value={RdbmsSqlManager.class})
    public RDBMStoreAction rdbmStoreAction() {
        return new RDBMStoreAction();
    }

    @Bean
    public MqttGatewayComponent mqttGatewayComponent() {
        return new MqttGatewayComponent();
    }

    @Bean
    public MqttStoreAction mqttStoreAction() {
        return new MqttStoreAction();
    }

    @Bean
    public StoreActionFactory storeActionFactory() {
        return StoreActionFactory.getInstance();
    }

    @Bean
    public DefaultMqttComponent defaultMqttComponent() {
        return new DefaultMqttComponent();
    }
}

