/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.vue;

import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.iteaj.iboot.msn.lcd.LowCodeProperties;
import com.iteaj.iboot.msn.lcd.utils.LowCodeUtil;
import com.iteaj.iboot.msn.lcd.vue.FormType;
import com.iteaj.util.CommonUtils;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VueFieldInfo {
    private String label;
    private String field;
    private String component;
    private boolean required;
    private FormType formType;
    private TableField tableField;
    private String searchComponent;
    private static final Pattern DICT_PATTERN = Pattern.compile("^.*(\u5b57\u5178?<type>[\\w|_]*).*");

    public VueFieldInfo(TableField tableField) {
        this.tableField = tableField;
    }

    public VueFieldInfo build(LowCodeProperties properties) {
        DbColumnType columnType = (DbColumnType)this.tableField.getColumnType();
        this.label = this.getLabel();
        this.formType = FormType.getType(columnType, this.tableField.getComment());
        if (this.isEditComponent(properties)) {
            this.component = this.formType.getTemplate(this.getField(), this.getLabel(), this.getExact());
        }
        if (this.isSearchComponent(properties)) {
            this.searchComponent = this.formType.getTemplate(this.getField(), this.getLabel(), ":allowClear=\"true\"");
        }
        return this;
    }

    public String getField() {
        return this.tableField.getPropertyName();
    }

    public boolean isRequired() {
        return this.tableField.getCustomMap() == null ? false : this.tableField.getCustomMap().get("null").equals("NO");
    }

    private String getExact() {
        Object aDefault;
        if (this.tableField.getCustomMap() != null && (aDefault = this.tableField.getCustomMap().get("default")) != null) {
            switch (this.formType) {
                case Input: 
                case Textarea: {
                    if (CommonUtils.isBlank((String)((String)aDefault))) {
                        return "";
                    }
                    return "defaultValue=\"" + aDefault + "\"";
                }
                case InputNumber: {
                    return ":defaultValue=\"" + aDefault + "\"";
                }
                case Dict: {
                    this.tableField.getComment().indexOf("\u5b57\u5178");
                }
            }
            return "";
        }
        return "";
    }

    public String getLabel() {
        return LowCodeUtil.removeBracket(this.tableField.getComment());
    }

    private boolean isEditComponent(LowCodeProperties properties) {
        Set<String> exclude = properties.getForm().getEdit();
        if (exclude != null) {
            for (String item : exclude) {
                if (!this.tableField.getName().equals(item)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSearchComponent(LowCodeProperties properties) {
        String name = this.tableField.getName();
        Set<String> include = properties.getForm().getSearch();
        if (include != null && CommonUtils.isNotBlank((String)name)) {
            for (String item : include) {
                if (!name.contains(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        Matcher matcher = DICT_PATTERN.matcher("\u6d4b\u8bd5 \u5b57\u5178\uff1atest_dict\u5730\u65b9");
        if (matcher.find()) {
            String group = matcher.group("type");
            System.out.println(group);
        }
    }

    public String getComponent() {
        return this.component;
    }

    public FormType getFormType() {
        return this.formType;
    }

    public TableField getTableField() {
        return this.tableField;
    }

    public String getSearchComponent() {
        return this.searchComponent;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setFormType(FormType formType) {
        this.formType = formType;
    }

    public void setTableField(TableField tableField) {
        this.tableField = tableField;
    }

    public void setSearchComponent(String searchComponent) {
        this.searchComponent = searchComponent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VueFieldInfo)) {
            return false;
        }
        VueFieldInfo other = (VueFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$component = this.getComponent();
        String other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        FormType this$formType = this.getFormType();
        FormType other$formType = other.getFormType();
        if (this$formType == null ? other$formType != null : !((Object)((Object)this$formType)).equals((Object)other$formType)) {
            return false;
        }
        TableField this$tableField = this.getTableField();
        TableField other$tableField = other.getTableField();
        if (this$tableField == null ? other$tableField != null : !this$tableField.equals(other$tableField)) {
            return false;
        }
        String this$searchComponent = this.getSearchComponent();
        String other$searchComponent = other.getSearchComponent();
        return !(this$searchComponent == null ? other$searchComponent != null : !this$searchComponent.equals(other$searchComponent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VueFieldInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        FormType $formType = this.getFormType();
        result = result * 59 + ($formType == null ? 43 : ((Object)((Object)$formType)).hashCode());
        TableField $tableField = this.getTableField();
        result = result * 59 + ($tableField == null ? 43 : $tableField.hashCode());
        String $searchComponent = this.getSearchComponent();
        result = result * 59 + ($searchComponent == null ? 43 : $searchComponent.hashCode());
        return result;
    }

    public String toString() {
        return "VueFieldInfo(label=" + this.getLabel() + ", field=" + this.getField() + ", component=" + this.getComponent() + ", required=" + this.isRequired() + ", formType=" + (Object)((Object)this.getFormType()) + ", tableField=" + this.getTableField() + ", searchComponent=" + this.getSearchComponent() + ")";
    }
}

