/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.spi.auth;

import com.iteaj.framework.autoconfigure.FrameworkProperties;
import com.iteaj.framework.result.HttpResult;
import com.iteaj.framework.spi.auth.AuthContext;
import com.iteaj.framework.spi.auth.AuthToken;
import com.iteaj.framework.spi.auth.AuthType;
import com.iteaj.framework.spi.auth.SecurityException;
import com.iteaj.framework.spi.auth.WebAuthAction;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AccountAuthAction
implements WebAuthAction<AuthContext> {
    private String[] urlPattern;
    private FrameworkProperties config;

    public AccountAuthAction(String[] urlPattern) {
        this.urlPattern = urlPattern;
    }

    @Override
    public String[] getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    public abstract String getLoginUrl();

    @Override
    public abstract String getSuccessUrl();

    @Override
    public boolean preAuthorize(HttpServletRequest request, HttpServletResponse response) {
        return !this.isLoginRequest(request);
    }

    @Override
    public AuthContext getContext(HttpServletRequest request, HttpServletResponse response) {
        return AuthContext.build(AuthType.Account);
    }

    @Override
    public boolean postAuthorize(HttpServletRequest request, HttpServletResponse response) throws SecurityException {
        if (this.isAjax(request)) {
            this.writeJson(HttpResult.StatusCode("unauthorized", 401), response);
        } else {
            try {
                response.sendRedirect(this.getLoginUrl());
            }
            catch (IOException e) {
                throw new SecurityException("\u8ba4\u8bc1\u5931\u8d25", e);
            }
        }
        return true;
    }

    @Override
    public abstract AuthToken login(AuthContext var1, HttpServletRequest var2, HttpServletResponse var3) throws SecurityException;

    public AccountAuthAction setUrlPattern(String ... urlPattern) {
        this.urlPattern = urlPattern;
        return this;
    }

    public FrameworkProperties getConfig() {
        return this.config;
    }

    @Autowired
    public AccountAuthAction setConfig(FrameworkProperties config) {
        this.config = config;
        return this;
    }
}

