/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.security.shiro;

import com.iteaj.framework.Entity;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.NativeSessionManager;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.util.ThreadContext;

public class ShiroUtil {
    public static Serializable getId() {
        Object user = ShiroUtil.getUser();
        return user != null ? (Serializable)user.getId() : null;
    }

    public static <T extends Entity> T getUser() {
        try {
            Object principal = SecurityUtils.getSubject().getPrincipal();
            if (principal instanceof Entity) {
                return (T)((Entity)principal);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isLogin() {
        return ShiroUtil.getUser() != null;
    }

    public static boolean isSuper() {
        if (ShiroUtil.getUser().getId() instanceof Number) {
            return ShiroUtil.isSuper(((Number)ShiroUtil.getUser().getId()).longValue());
        }
        return false;
    }

    public static boolean isSuper(Long id) {
        return id == 1L;
    }

    public static void offline(Object session) throws UnknownSessionException {
        SecurityManager securityManager = SecurityUtils.getSecurityManager();
        if (securityManager instanceof SessionsSecurityManager) {
            SessionManager sessionManager = ((SessionsSecurityManager)securityManager).getSessionManager();
            if (sessionManager instanceof NativeSessionManager) {
                DefaultSessionKey sessionKey = new DefaultSessionKey((Serializable)session);
                ((NativeSessionManager)sessionManager).stop((SessionKey)sessionKey);
            }
        } else {
            throw new IllegalStateException("\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
    }

    public static Session getSession(String sessionId) {
        SecurityManager securityManager = SecurityUtils.getSecurityManager();
        if (securityManager instanceof SessionsSecurityManager) {
            SessionManager sessionManager = ((SessionsSecurityManager)securityManager).getSessionManager();
            if (sessionManager instanceof NativeSessionManager) {
                try {
                    return sessionManager.getSession((SessionKey)new DefaultSessionKey((Serializable)((Object)sessionId)));
                }
                catch (UnknownSessionException e) {
                    return null;
                }
            }
            throw new IllegalStateException("\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        throw new IllegalStateException("\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }

    public static UserAgent getAgent() {
        return (UserAgent)ShiroUtil.getRequest().getAttribute("WEB_USER_AGENT");
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)ThreadContext.get((Object)"HTTP_SERVLET_REQUEST");
    }

    public static <T> T getRequestAttr(String key) {
        return (T)ShiroUtil.getRequest().getAttribute(key);
    }

    public static void setRequestAttr(String key, Object value) {
        ShiroUtil.getRequest().setAttribute(key, value);
    }
}

