/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.autoconfigure;

import com.iteaj.framework.autoconfigure.FrameworkProperties;
import com.iteaj.framework.autoconfigure.SessionCacheProperties;
import com.iteaj.framework.security.OrderFilterChainDefinition;
import com.iteaj.framework.security.shiro.AccessFilterWrapper;
import com.iteaj.framework.security.shiro.ShiroFilterLogFactoryBean;
import com.iteaj.framework.security.shiro.online.OnlineSessionDAO;
import com.iteaj.framework.security.shiro.online.OnlineSessionManager;
import com.iteaj.framework.security.shiro.redis.ShiroRedisSessionCacheManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.aopalliance.aop.Advice;
import org.apache.shiro.authc.AbstractAuthenticator;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.security.interceptor.AopAllianceAnnotationsAuthorizingMethodInterceptor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;

@ImportAutoConfiguration(value={RedisSessionCacheManagerConfiguration.class})
@EnableConfigurationProperties(value={SessionCacheProperties.class})
public class ShiroAutoConfiguration {
    private final FrameworkProperties properties;
    private final SessionCacheProperties cacheProperties;
    @Autowired
    private ObjectProvider<AuthenticationListener> authentication;

    public ShiroAutoConfiguration(FrameworkProperties properties, SessionCacheProperties cacheProperties) {
        this.properties = properties;
        this.cacheProperties = cacheProperties;
    }

    @Bean
    @Order(value=99999)
    public OrderFilterChainDefinition frameworkAuthFilterChainDefinition() {
        OrderFilterChainDefinition chain = new OrderFilterChainDefinition();
        chain.addPathDefinition("/**", "framework");
        return chain;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(RealmSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor sourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        sourceAdvisor.setSecurityManager((SecurityManager)securityManager);
        sourceAdvisor.setAdvice((Advice)new AopAllianceAnnotationsAuthorizingMethodInterceptor());
        return sourceAdvisor;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(List<OrderFilterChainDefinition> definitions, SecurityManager securityManager, List<AccessFilterWrapper> filters) {
        ShiroFilterLogFactoryBean factoryBean = new ShiroFilterLogFactoryBean();
        factoryBean.setSecurityManager(securityManager);
        Map<String, Filter> nameableFilterMap = filters.stream().collect(Collectors.toMap(item -> item.getName(), item -> item.getFilter()));
        factoryBean.setFilters(nameableFilterMap);
        LinkedHashMap pathDefinition = new LinkedHashMap();
        definitions.stream().forEach(definition -> pathDefinition.putAll(definition.getFilterChainMap()));
        factoryBean.setFilterChainDefinitionMap(pathDefinition);
        return factoryBean;
    }

    @Bean
    public SessionDAO sessionDAO() {
        OnlineSessionDAO sessionDAO = new OnlineSessionDAO();
        sessionDAO.setActiveSessionsCacheName(this.cacheProperties.getName());
        return sessionDAO;
    }

    @Bean
    public RealmSecurityManager securityManager(Collection<SessionListener> listeners, SessionDAO sessionDAO, Collection<Realm> realms, ObjectProvider<CacheManager> cacheManager) {
        OnlineSessionManager sessionManager = new OnlineSessionManager(this.properties);
        sessionManager.setSessionValidationSchedulerEnabled(true);
        long expireTime = TimeUnit.SECONDS.toMillis(this.cacheProperties.getExpire());
        sessionManager.setGlobalSessionTimeout(expireTime);
        sessionManager.setSessionDAO(sessionDAO);
        sessionManager.setSessionListeners(listeners);
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealms(realms);
        securityManager.setSessionManager((SessionManager)sessionManager);
        Authenticator authenticator = securityManager.getAuthenticator();
        if (authenticator instanceof AbstractAuthenticator) {
            ArrayList authenticationListeners = this.authentication.stream().collect(Collectors.toCollection(ArrayList::new));
            ((AbstractAuthenticator)authenticator).setAuthenticationListeners((Collection)authenticationListeners);
        }
        cacheManager.ifAvailable(item -> securityManager.setCacheManager(item));
        return securityManager;
    }

    @ConditionalOnProperty(value={"framework.shiro.redis"}, havingValue="true")
    public static class RedisSessionCacheManagerConfiguration {
        @Bean
        public CacheManager cacheManager(RedisTemplate redisTemplate, SessionCacheProperties properties) {
            return new ShiroRedisSessionCacheManager(redisTemplate, properties);
        }
    }
}

