/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.autoconfigure;

import com.alibaba.fastjson.support.spring.FastJsonRedisSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@ConditionalOnClass(name={"org.springframework.data.redis.core.RedisTemplate"})
public class RedisJsonAutoConfiguration {
    @Primary
    @Bean(value={"redisTemplate", "jsonRedisTemplate"})
    @ConditionalOnClass(name={"com.fasterxml.jackson.databind.ObjectMapper"})
    public RedisTemplate jacksonRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(redisTemplate.getStringSerializer());
        redisTemplate.setHashKeySerializer(redisTemplate.getStringSerializer());
        Jackson2JsonRedisSerializer valueSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.PUBLIC_ONLY);
        objectMapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL);
        valueSerializer.setObjectMapper(objectMapper);
        redisTemplate.setValueSerializer((RedisSerializer)valueSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)valueSerializer);
        return redisTemplate;
    }

    @Bean(value={"redisTemplate", "jsonRedisTemplate"})
    @ConditionalOnClass(name={"com.alibaba.fastjson.support.spring.FastJsonRedisSerializer"})
    public RedisTemplate fastjsonRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(redisTemplate.getStringSerializer());
        redisTemplate.setHashKeySerializer(redisTemplate.getStringSerializer());
        FastJsonRedisSerializer valueSerializer = new FastJsonRedisSerializer(Object.class);
        redisTemplate.setValueSerializer((RedisSerializer)valueSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)valueSerializer);
        return redisTemplate;
    }
}

