/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.quartz.jobs;

import com.iteaj.iboot.msn.quartz.jobs.QuartzJob;
import com.iteaj.iboot.msn.quartz.jobs.QuartzJobContext;
import com.iteaj.iboot.msn.quartz.jobs.QuartzTask;
import com.iteaj.iboot.msn.quartz.jobs.SpringSupportJob;
import com.iteaj.util.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class SpringSupportJob
implements Job,
JobFactory,
BeanFactoryAware,
BeanPostProcessor {
    private AutowireCapableBeanFactory beanFactory;
    public static final Class<EmptyJob> EMPTY_JOB = EmptyJob.class;
    public static final String JOB_EXPRESSION = "METHOD:EXPRESSION";
    private List<Map<String, String>> optionValues = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(SpringSupportJob.class);
    private Map<String, QuartzJobContext> cache = new ConcurrentHashMap(16);
    public static final Class<NonConcurrentEmptyJob> NON_CONCURRENT_EMPTY_JOB = NonConcurrentEmptyJob.class;

    public Job newJob(TriggerFiredBundle triggerFiredBundle, Scheduler scheduler) throws SchedulerException {
        Class jobClass = triggerFiredBundle.getJobDetail().getJobClass();
        if (EmptyJob.class.isAssignableFrom(jobClass)) {
            return this;
        }
        boolean containsBean = this.beanFactory.containsBean(jobClass.getName());
        if (containsBean) {
            return (Job)this.beanFactory.getBean(jobClass);
        }
        Job job = (Job)BeanUtils.instantiateClass((Class)jobClass);
        this.beanFactory.autowireBean((Object)job);
        return job;
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap dataMap = jobDetail.getJobDataMap();
        String expression = dataMap.getString(JOB_EXPRESSION);
        QuartzJobContext context = this.getContext(expression);
        if (context != null) {
            if (context != null) {
                Object result = context.invoke(expression, jobExecutionContext);
                jobExecutionContext.setResult(result);
            } else {
                jobExecutionContext.setResult((Object)("\u65b9\u6cd5\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u80fd\u8bbf\u95ee[" + expression + "]"));
                this.logger.warn("[quartz]\u6267\u884c\u65b9\u6cd5\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u80fd\u8bbf\u95ee[" + expression + "]");
            }
        } else {
            jobExecutionContext.setResult((Object)("job[" + jobDetail.getKey().getName() + "]\u6ca1\u6709\u6307\u5b9a\u8981\u6267\u884c\u7684\u65b9\u6cd5"));
            this.logger.warn("[quartz]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6267\u884c\u65b9\u6cd5[" + expression + "]");
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        QuartzTask annotation = bean.getClass().getAnnotation(QuartzTask.class);
        if (annotation != null) {
            ReflectionUtils.doWithLocalMethods(bean.getClass(), method -> {
                QuartzJob methodAnnotation = method.getAnnotation(QuartzJob.class);
                if (methodAnnotation == null) {
                    return;
                }
                String name = beanName + "." + method.getName();
                QuartzJobContext context = (QuartzJobContext)this.cache.get(name);
                if (context != null) {
                    throw new BeanCreationException(String.format("\u5b9a\u65f6\u4efb\u52a1\u65b9\u6cd5\u91cd\u590d[%s -> %s]", beanName, name));
                }
                this.cache.put(name, new QuartzJobContext(bean, method));
                HashMap<String, String> option = new HashMap<String, String>();
                option.put("label", name);
                option.put("value", name);
                this.optionValues.add(option);
            });
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    public QuartzJobContext getContext(String expression) {
        if (CommonUtils.isNotBlank((String)expression)) {
            return (QuartzJobContext)this.cache.get(expression);
        }
        return null;
    }

    public List<Map<String, String>> getOptionValues() {
        return this.optionValues;
    }
}

