/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.quartz;

import com.iteaj.iboot.msn.quartz.jobs.SpringSupportJob;
import com.iteaj.iboot.msn.quartz.scheduler.SchedulerManager;
import javax.sql.DataSource;
import org.mybatis.spring.annotation.MapperScan;
import org.quartz.Scheduler;
import org.quartz.spi.JobFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Profile(value={"qrtz"})
@EnableScheduling
@ComponentScan(value={"com.iteaj.iboot.msn.quartz"})
@MapperScan(value={"com.iteaj.iboot.msn.quartz.mapper"})
public class QuartzAutoConfiguration
implements BeanFactoryPostProcessor,
BeanDefinitionRegistryPostProcessor {
    private static final String DEFAULT_JOB_GROUP_NAME = "JOB:GROUP:IBOOT";
    private static final String DEFAULT_TRIGGER_GROUP_NAME = "TRIGGER:GROUP:IBOOT";

    @Bean(value={"schedulerFactoryBean"})
    public SchedulerFactoryBean schedulerFactoryBean(JobFactory jobFactory, DataSource dataSource) {
        SchedulerFactoryBean factoryBean = new SchedulerFactoryBean();
        factoryBean.setJobFactory(jobFactory);
        factoryBean.setConfigLocation((Resource)new ClassPathResource("quartz.properties"));
        factoryBean.setStartupDelay(20);
        factoryBean.setDataSource(dataSource);
        return factoryBean;
    }

    @Bean(value={"scheduler"})
    public Scheduler sysScheduler(SchedulerFactoryBean schedulerFactoryBean) {
        return schedulerFactoryBean.getScheduler();
    }

    @Bean(value={"defaultSchedulerManager"})
    public SchedulerManager defaultSchedulerManager(Scheduler scheduler) {
        return new SchedulerManager(scheduler, DEFAULT_JOB_GROUP_NAME, DEFAULT_TRIGGER_GROUP_NAME);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SpringSupportJob bean = (SpringSupportJob)beanFactory.getBean(SpringSupportJob.class);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)bean);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        boolean b = registry.containsBeanDefinition(SpringSupportJob.class.getName());
        if (b) {
            return;
        }
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(SpringSupportJob.class);
        beanDefinition.setAutowireCandidate(true);
        registry.registerBeanDefinition(SpringSupportJob.class.getName(), (BeanDefinition)beanDefinition);
    }
}

