/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.consts.DeviceTypeAlias;
import com.iteaj.iboot.msn.iot.consts.TypeAliasOptions;
import com.iteaj.iboot.msn.iot.entity.DeviceType;
import com.iteaj.iboot.msn.iot.service.IDeviceTypeService;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/deviceType"})
public class DeviceTypeController
extends BaseController {
    private final IDeviceTypeService deviceTypeService;

    public DeviceTypeController(IDeviceTypeService deviceTypeService) {
        this.deviceTypeService = deviceTypeService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:deviceType:view"})
    public Result<List<DeviceType>> list(DeviceType entity) {
        return this.deviceTypeService.tree(entity);
    }

    @GetMapping(value={"/tree"})
    public Result<List<DeviceType>> tree(String alias) {
        DeviceType type = new DeviceType();
        type.setAlias(alias);
        return this.deviceTypeService.tree(type);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:deviceType:edit"})
    public Result<DeviceType> getEditDetail(Long id) {
        return this.deviceTypeService.getById((Serializable)id);
    }

    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:deviceType:edit"})
    public Result<Boolean> edit(@RequestBody DeviceType entity) {
        return this.deviceTypeService.updateById((Entity)entity);
    }

    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"iot:deviceType:add"})
    public Result<Boolean> add(@RequestBody DeviceType entity) {
        return this.deviceTypeService.save((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:deviceType:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.deviceTypeService.removeByIds(idList);
    }

    @GetMapping(value={"alias"})
    public Result<List<TypeAliasOptions>> alias() {
        return this.success((Object)DeviceTypeAlias.options());
    }
}

