/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.consts.DeviceStatus;
import com.iteaj.iboot.msn.iot.debug.tcp.server.TcpDebugServerComponent;
import com.iteaj.iboot.msn.iot.entity.Device;
import com.iteaj.iboot.msn.iot.service.IDeviceService;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.DeviceManager;
import com.iteaj.iot.client.mqtt.impl.DefaultMqttComponent;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/debug"})
public class DeviceDebugController
extends BaseController {
    private final IDeviceService deviceService;
    private final DefaultMqttComponent component;
    private final TcpDebugServerComponent tcpDebugServerComponent;

    public DeviceDebugController(@Autowired(required=false) DefaultMqttComponent component, @Autowired(required=false) TcpDebugServerComponent tcpDebugServerComponent, IDeviceService deviceService) {
        this.component = component;
        this.deviceService = deviceService;
        this.tcpDebugServerComponent = tcpDebugServerComponent;
    }

    @GetMapping(value={"tcp"})
    public Result<IPage<Device>> tcpList(Page page) {
        if (this.tcpDebugServerComponent != null) {
            DeviceManager deviceManager = this.tcpDebugServerComponent.getDeviceManager();
            page.setTotal((long)deviceManager.size()).setRecords(new ArrayList());
            deviceManager.forEach(item -> {
                InetSocketAddress address = (InetSocketAddress)item.remoteAddress();
                Long timeMills = (Long)item.attr(CoreConst.CLIENT_ONLINE_TIME).get();
                Device device = new Device().setIp(address.getHostName()).setPort(Integer.valueOf(address.getPort())).setStatus(DeviceStatus.online).setSwitchTime(new Date(timeMills)).setName(item.id().asShortText());
                Object o = item.attr(CoreConst.EQUIP_CODE).get();
                if (o != null) {
                    device.setDeviceSn(o.toString());
                }
                page.getRecords().add(device);
            });
            return this.success((Object)page);
        }
        return this.success();
    }

    @GetMapping(value={"mqtt/subscribe"})
    public Result<Boolean> subscribe(String topic, MqttQoS qoS) {
        this.component.subscribe(topic, qoS);
        return this.success((Object)true);
    }
}

