/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.exception.ServiceException;
import com.iteaj.iboot.msn.iot.collect.CollectActionFactory;
import com.iteaj.iboot.msn.iot.collect.CollectActionTask;
import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.CollectAction;
import com.iteaj.iboot.msn.iot.collect.store.StoreActionFactory;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.entity.CollectTask;
import com.iteaj.iboot.msn.iot.service.ICollectTaskService;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CollectService
implements InitializingBean {
    private final CollectActionFactory actionFactory;
    private final ThreadPoolTaskScheduler scheduler;
    private final StoreActionFactory storeActionFactory;
    private final ICollectTaskService collectTaskService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Long, ScheduledFuture> scheduledFutureMap = new ConcurrentHashMap();

    public CollectService(CollectActionFactory actionFactory, ThreadPoolTaskScheduler scheduler, StoreActionFactory storeActionFactory, ICollectTaskService collectTaskService) {
        this.actionFactory = actionFactory;
        this.scheduler = scheduler;
        this.storeActionFactory = storeActionFactory;
        this.collectTaskService = collectTaskService;
    }

    public void statusSwitch(Long id, String status) throws CollectException {
        CollectTaskDto taskDto = this.collectTaskService.collectDetailById(id);
        if (taskDto == null) {
            throw new ServiceException("\u91c7\u96c6\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (taskDto.getStatus().equals(status)) {
            throw new ServiceException("\u72b6\u6001\u5207\u6362\u5f02\u5e38");
        }
        if (status.equals("run")) {
            ScheduledFuture future = (ScheduledFuture)this.scheduledFutureMap.get(id);
            Object result = this.validateTask(taskDto);
            if (result instanceof String) {
                throw new CollectException((String)result);
            }
            if (future == null) {
                this.createScheduledTask(taskDto);
            } else if (future.isCancelled()) {
                this.scheduledFutureMap.remove(id);
                this.createScheduledTask(taskDto);
            }
        } else if (status.equals("stop")) {
            ScheduledFuture future = (ScheduledFuture)this.scheduledFutureMap.remove(id);
            if (future != null && !future.isCancelled()) {
                future.cancel(true);
            }
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u72b6\u6001[" + status + "]");
        }
        this.collectTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(CollectTask::getStatus, (Object)status)).set(CollectTask::getReason, (Object)"")).set(CollectTask::getUpdateTime, (Object)new Date())).eq(BaseEntity::getId, (Object)id));
    }

    public void afterPropertiesSet() throws Exception {
        this.collectTaskService.list((Wrapper)Wrappers.lambdaQuery().eq(CollectTask::getStatus, (Object)"run")).stream().map(item -> this.collectTaskService.collectDetailById(item.getId())).filter(item -> item != null && !CollectionUtils.isEmpty((Collection)item.getDetails())).map(item -> this.validateTask(item)).filter(item -> item instanceof CollectTaskDto).forEach(item -> this.createScheduledTask((CollectTaskDto)item));
    }

    private Object validateTask(CollectTaskDto taskDto) {
        try {
            if (!StringUtils.hasText((String)taskDto.getCron())) {
                this.collectTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(CollectTask::getStatus, (Object)"fail")).set(CollectTask::getReason, (Object)"\u6ca1\u6709\u914d\u7f6ecron")).eq(BaseEntity::getId, (Object)taskDto.getId()));
                return "\u6ca1\u6709\u914d\u7f6ecron";
            }
            taskDto.getDetails().forEach(item -> {
                CollectAction collectAction;
                String reason = null;
                if (item.getDevice() == null) {
                    reason = "\u6ca1\u6709\u914d\u7f6e\u91c7\u96c6\u8bbe\u5907";
                }
                if (CollectionUtils.isEmpty((Collection)item.getSignals())) {
                    reason = "\u6ca1\u6709\u914d\u7f6e\u91c7\u96c6\u70b9\u4f4d";
                }
                if ((collectAction = this.actionFactory.get(item.getCollectAction())) == null) {
                    reason = "\u6ca1\u6709\u53ef\u7528\u7684\u91c7\u96c6\u52a8\u4f5c[action=" + item.getCollectAction() + "]";
                } else {
                    try {
                        collectAction.validate(item);
                        item.getSignals().forEach(signal -> collectAction.validate(signal));
                    }
                    catch (CollectException e) {
                        reason = e.getMessage();
                    }
                }
                if (reason != null) {
                    this.collectTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(CollectTask::getStatus, (Object)"fail")).set(CollectTask::getReason, (Object)reason)).set(CollectTask::getUpdateTime, null)).eq(BaseEntity::getId, (Object)taskDto.getId()));
                    throw new CollectException(reason);
                }
            });
        }
        catch (CollectException e) {
            this.logger.error("\u6821\u9a8c\u4efb\u52a1\u5931\u8d25 \u4efb\u52a1:{} - \u5931\u8d25\u539f\u56e0: {}", (Object)taskDto.getName(), (Object)e.getMessage());
            return e.getMessage();
        }
        catch (Exception e) {
            this.logger.error("\u6821\u9a8c\u4efb\u52a1\u5931\u8d25 \u4efb\u52a1:{} - \u5931\u8d25\u539f\u56e0: {}", new Object[]{taskDto.getName(), e.getMessage(), e});
            return e.getMessage();
        }
        return taskDto;
    }

    private void createScheduledTask(CollectTaskDto taskDto) {
        this.scheduledFutureMap.put(taskDto.getId(), this.scheduler.schedule((Runnable)new CollectActionTask(taskDto), (Trigger)new CronTrigger(taskDto.getCron())));
    }
}

