/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.core.dto.RoleDto;
import com.iteaj.iboot.msn.core.dto.RoleFuncDto;
import com.iteaj.iboot.msn.core.entity.Menu;
import com.iteaj.iboot.msn.core.entity.Role;
import com.iteaj.iboot.msn.core.service.IMenuService;
import com.iteaj.iboot.msn.core.service.IRoleService;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/core/role"})
public class RoleController
extends BaseController {
    private final IRoleService roleService;
    private final IMenuService menuService;

    public RoleController(IRoleService roleService, IMenuService menuService) {
        this.roleService = roleService;
        this.menuService = menuService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"core:role:view"})
    public Result<IPage<Role>> view(Page page, Role role) {
        page.addOrder(new OrderItem[]{OrderItem.asc((String)"sort")});
        return this.roleService.page((IPage)page, (Entity)role);
    }

    @GetMapping(value={"/list"})
    public Result<List<Role>> list(Role role) {
        return this.roleService.list((Entity)role);
    }

    @GetMapping(value={"allMenus"})
    public Result<List<Menu>> allFunc() {
        return this.menuService.selectMenuTrees(new Menu());
    }

    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"core:add:view"})
    public Result add(@RequestBody RoleDto role) {
        this.roleService.createRoleAndPerms(role);
        return this.success();
    }

    @GetMapping(value={"/edit"})
    public Result<Role> edit(Long id) {
        return this.roleService.getById((Serializable)id);
    }

    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"core:role:edit"})
    public Result<Boolean> edit(@RequestBody Role role) {
        return this.roleService.updateById((Entity)role);
    }

    @GetMapping(value={"/func"})
    public Result<RoleFuncDto> func(Long id) {
        RoleFuncDto roleFuncDto = new RoleFuncDto(id, (List)this.roleService.listMenusOfRole(id).getData());
        return this.success((Object)roleFuncDto);
    }

    @PostMapping(value={"/perm"})
    @RequiresPermissions(value={"core:role:perm"})
    public Result<Boolean> editFunc(@RequestBody RoleDto role) {
        this.roleService.updateRolePermsById(role);
        return this.success();
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"core:del:view"})
    public Result del(@RequestBody List<Long> list) {
        this.roleService.delRoleAndPermByIds(list);
        return this.success();
    }
}

