/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core;

import cn.afterturn.easypoi.handler.inter.IExcelDictHandler;
import com.iteaj.framework.autoconfigure.CaptchaAutoConfiguration;
import com.iteaj.framework.autoconfigure.FrameworkWebConfiguration;
import com.iteaj.framework.autoconfigure.ShiroAutoConfiguration;
import com.iteaj.framework.logger.LoggerService;
import com.iteaj.framework.security.OrderFilterChainDefinition;
import com.iteaj.framework.security.shiro.AccessFilterWrapper;
import com.iteaj.framework.spi.admin.ResourceManager;
import com.iteaj.framework.spi.excel.ExcelDictHandle;
import com.iteaj.framework.spi.excel.IExcelService;
import com.iteaj.iboot.msn.core.CoreProperties;
import com.iteaj.iboot.msn.core.config.shiro.ShiroAdminAuthRealm;
import com.iteaj.iboot.msn.core.config.shiro.ShiroAdminFilter;
import com.iteaj.iboot.msn.core.config.shiro.ShiroOnlineListener;
import com.iteaj.iboot.msn.core.exception.AsyncExceptionHandler;
import com.iteaj.iboot.msn.core.service.AdminLoggerService;
import com.iteaj.iboot.msn.core.service.AdminResourceManager;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableAsync
@ImportAutoConfiguration(value={ShiroAutoConfiguration.class, CaptchaAutoConfiguration.class, FrameworkWebConfiguration.class})
@ComponentScan(value={"com.iteaj.iboot.msn.core"})
@MapperScan(value={"com.iteaj.iboot.msn.core.mapper"})
@EnableConfigurationProperties(value={CoreProperties.class})
public class CoreAutoConfiguration
implements WebMvcConfigurer,
AsyncConfigurer {
    private final CoreProperties coreProperties;

    public CoreAutoConfiguration(CoreProperties coreProperties) {
        this.coreProperties = coreProperties;
    }

    @Bean
    public TaskScheduler taskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean
    public ResourceManager menuResourceManager() {
        return new AdminResourceManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultAdvisorAutoProxyCreator.class})
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean(value={"frameworkAuthRealm"})
    public ShiroAdminAuthRealm shiroAdminAuthRealm() {
        return new ShiroAdminAuthRealm();
    }

    @Bean(value={"frameworkAccessFilter"})
    public AccessFilterWrapper frameworkAccessFilter() {
        return new AccessFilterWrapper("framework", (AccessControlFilter)new ShiroAdminFilter());
    }

    @Bean
    @Order(value=18)
    public OrderFilterChainDefinition staticFilterChainDefinition() {
        OrderFilterChainDefinition chain = new OrderFilterChainDefinition();
        chain.addPathDefinition("/core/login", "anon");
        chain.addPathDefinition("/js/**", "anon");
        chain.addPathDefinition("/css/**", "anon");
        chain.addPathDefinition("/img/**", "anon");
        chain.addPathDefinition("/libs/**", "anon");
        chain.addPathDefinition("/static/**", "anon");
        chain.addPathDefinition("/doc/**", "anon");
        chain.addPathDefinition("/favicon.ico", "anon");
        return chain;
    }

    @Bean
    public SessionListener eventSessionListener() {
        return new ShiroOnlineListener();
    }

    @Bean
    public LoggerService loggerService() {
        return new AdminLoggerService();
    }

    @Bean
    public IExcelDictHandler excelDictHandler(IExcelService excelService) {
        return new ExcelDictHandle(excelService);
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new AsyncExceptionHandler();
    }
}

